#!perl

use warnings;
use strict;
use Benchmark;

my $count    = $ENV{'COUNT'} || 1;
my $data_pos = tell DATA;
my $lines    = 49;

use Net::ISC::DHCPd::Config;

my $time = timeit($count, sub {
    seek DATA, $data_pos, 0;
    my $config = Net::ISC::DHCPd::Config->new(filehandle => \*DATA);
    $config->parse;
});

print(($lines * $count) .": " .timestr($time));

__DATA__
ddns-update-style none;

option space foo;
option foo.bar code 1 = ip-address;
option foo.baz code 2 = ip-address;
option foo-enc code 122 = encapsulate foo;

option domain-name-servers 84.208.20.110, 84.208.20.111;
default-lease-time 86400;
max-lease-time 86400;

on commit {
    set leasetime = encode-int(lease-time, 32);
    if(1) {
        set hw_addr   = substring(hardware, 1, 8);
    }
}

subnet 10.0.0.96 netmask 255.255.255.224
{
    option domain-name "isc.org";
    option domain-name-servers ns1.isc.org, ns2.isc.org;
    option routers 10.0.0.97;

    pool {

        range 10.0.0.98 10.0.0.103;
    }
    pool
    {
        range 10.0.0.105 10.0.0.114;
    }
    pool {
        range 10.0.0.116 10.0.0.126;
    }
}

shared-network {
    subnet 10.0.0.1 netmask 255.255.255.0 {
    }
    subnet 10.0.1.1 netmask 255.255.255.0 {
    }
}

host foo {
  fixed-address 10.19.83.102;
  hardware ethernet 00:0e:35:d1:27:e3;
}

