# Generated by default/object.tt
package Paws::SecurityHub::StatusReason;
  use Moose;
  has Description => (is => 'ro', isa => 'Str');
  has ReasonCode => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::StatusReason

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::StatusReason object:

  $service_obj->Method(Att1 => { Description => $value, ..., ReasonCode => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::StatusReason object:

  $result = $service_obj->Method(...);
  $result->Att1->Description

=head1 DESCRIPTION

Provides additional context for the value of C<Compliance.Status>.

=head1 ATTRIBUTES


=head2 Description => Str

The corresponding description for the status reason code.


=head2 B<REQUIRED> ReasonCode => Str

A code that represents a reason for the control status. For the list of
status reason codes and their meanings, see Standards-related
information in the ASFF
(https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-results.html#securityhub-standards-results-asff)
in the I<AWS Security Hub User Guide>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

