# Generated by WebService::BitbucketServer::WADL - DO NOT EDIT!
package WebService::BitbucketServer::Core::V1;
# ABSTRACT: Bindings for a Bitbucket Server REST API


use warnings;
use strict;

our $VERSION = '0.605'; # VERSION

use Moo;
use namespace::clean;


has context => (
    is          => 'ro',
    isa         => sub { die 'Not a WebService::BitbucketServer' if !$_[0]->isa('WebService::BitbucketServer'); },
    required    => 1,
);


sub _croak { require Carp; Carp::croak(@_) }

sub _get_url {
    my $url  = shift;
    my $args = shift || {};
    $url =~ s/\{([^:}]+)(?::\.\*)?\}/_get_path_parameter($1, $args)/eg;
    return $url;
}

sub _get_path_parameter {
    my $name = shift;
    my $args = shift || {};
    return delete $args->{$name} if defined $args->{$name};
    $name =~ s/([A-Z])/'_'.lc($1)/eg;
    return delete $args->{$name} if defined $args->{$name};
    _croak("Missing required parameter $name");
}


sub get_cluster_information {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/cluster', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub get_groups {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/groups', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub create_group {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/groups', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub delete_group {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/groups', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'DELETE', url => $url, $data ? (data => $data) : ());
}


sub add_user_to_group {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/groups/add-user', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub add_users_to_group {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/groups/add-users', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub find_users_in_group {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/groups/more-members', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub find_users_not_in_group {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/groups/more-non-members', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub remove_user_from_group {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/groups/remove-user', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub get_license {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/license', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub update_license {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/license', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub delete_mail_config {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/mail-server', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'DELETE', url => $url, $data ? (data => $data) : ());
}


sub get_mail_config {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/mail-server', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub set_mail_config {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/mail-server', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'PUT', url => $url, $data ? (data => $data) : ());
}


sub clear_sender_address {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/mail-server/sender-address', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'DELETE', url => $url, $data ? (data => $data) : ());
}


sub get_sender_address {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/mail-server/sender-address', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub set_sender_address {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/mail-server/sender-address', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'PUT', url => $url, $data ? (data => $data) : ());
}


sub set_permission_for_groups {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/permissions/groups', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'PUT', url => $url, $data ? (data => $data) : ());
}


sub get_groups_with_any_permission {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/permissions/groups', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub revoke_permissions_for_group {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/permissions/groups', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'DELETE', url => $url, $data ? (data => $data) : ());
}


sub get_groups_without_any_permission {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/permissions/groups/none', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub set_permission_for_users {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/permissions/users', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'PUT', url => $url, $data ? (data => $data) : ());
}


sub get_users_with_any_permission {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/permissions/users', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub revoke_permissions_for_user {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/permissions/users', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'DELETE', url => $url, $data ? (data => $data) : ());
}


sub get_users_without_any_permission {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/permissions/users/none', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub set_merge_config {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/pull-requests/{scmId}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub get_merge_config {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/pull-requests/{scmId}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub get_users {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/users', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub update_user_details {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/users', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'PUT', url => $url, $data ? (data => $data) : ());
}


sub create_user {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/users', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub delete_user {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/users', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'DELETE', url => $url, $data ? (data => $data) : ());
}


sub add_group_to_user {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/users/add-group', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub add_user_to_groups {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/users/add-groups', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub clear_user_captcha_challenge {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/users/captcha', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'DELETE', url => $url, $data ? (data => $data) : ());
}


sub update_user_password {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/users/credentials', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'PUT', url => $url, $data ? (data => $data) : ());
}


sub find_groups_for_user {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/users/more-members', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub find_other_groups_for_user {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/users/more-non-members', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub remove_group_from_user {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/users/remove-group', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub rename_user {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/admin/users/rename', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub get_application_properties {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/application-properties', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub get_dashboard_pull_request_suggestions {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/dashboard/pull-request-suggestions', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub get_dashboard_pull_requests {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/dashboard/pull-requests', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub get_group_names {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/groups', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub get_avatar {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/hooks/{hookKey}/avatar', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub get_inbox_pull_requests {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/inbox/pull-requests', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub get_inbox_pull_request_count {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/inbox/pull-requests/count', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub get_level {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/logs/logger/{loggerName}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub set_level {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/logs/logger/{loggerName}/{levelName}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'PUT', url => $url, $data ? (data => $data) : ());
}


sub get_root_level {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/logs/rootLogger', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub set_root_level {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/logs/rootLogger/{levelName}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'PUT', url => $url, $data ? (data => $data) : ());
}


sub preview {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/markup/preview', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub get_repositories_recently_accessed {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/profile/recent/repos', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub get_projects {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub create_project {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub get_project {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub delete_project {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'DELETE', url => $url, $data ? (data => $data) : ());
}


sub update_project {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'PUT', url => $url, $data ? (data => $data) : ());
}


sub get_project_avatar {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/avatar.png', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub upload_project_avatar {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/avatar.png', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub set_project_permission_for_groups {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/permissions/groups', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'PUT', url => $url, $data ? (data => $data) : ());
}


sub get_groups_with_any_project_permission {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/permissions/groups', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub revoke_project_permissions_for_group {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/permissions/groups', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'DELETE', url => $url, $data ? (data => $data) : ());
}


sub get_groups_without_any_project_permission {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/permissions/groups/none', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub set_project_permission_for_users {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/permissions/users', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'PUT', url => $url, $data ? (data => $data) : ());
}


sub get_users_with_any_project_permission {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/permissions/users', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub revoke_project_permissions_for_user {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/permissions/users', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'DELETE', url => $url, $data ? (data => $data) : ());
}


sub get_users_without_project_permission {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/permissions/users/none', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub modify_all_user_project_permission {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/permissions/{permission}/all', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub has_all_user_project_permission {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/permissions/{permission}/all', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub create_repository {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub get_repositories {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub get_repository {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub update_repository {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'PUT', url => $url, $data ? (data => $data) : ());
}


sub delete_repository {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'DELETE', url => $url, $data ? (data => $data) : ());
}


sub fork_repository {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub get_archive {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/archive', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub create_branch {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/branches', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub get_branches {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/branches', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub get_default_branch {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/branches/default', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub set_default_branch {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/branches/default', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'PUT', url => $url, $data ? (data => $data) : ());
}


sub get_file {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/browse/{path:.*}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub edit_file {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/browse/{path:.*}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'PUT', url => $url, $data ? (data => $data) : ());
}


sub get_repository_changes {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/changes', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub get_repository_commits {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub get_commit {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub get_commit_changes {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/changes', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub get_commit_comments {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/comments', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub create_commit_comment {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/comments', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub get_commit_comment {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/comments/{commentId}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub delete_commit_comment {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/comments/{commentId}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'DELETE', url => $url, $data ? (data => $data) : ());
}


sub update_commit_comment {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/comments/{commentId}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'PUT', url => $url, $data ? (data => $data) : ());
}


sub stream_commit_diff {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/diff/{path:.*}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub watch_commit {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/watch', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub unwatch_commit {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/watch', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'DELETE', url => $url, $data ? (data => $data) : ());
}


sub stream_changes {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/compare/changes', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub stream_commits {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/compare/commits', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub stream_diff {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/compare/diff{path:.*}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub stream_repository_diff {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/diff/{path:.*}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub get_repository_files {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/files/{path:.*}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub get_forked_repositories {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/forks', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub stream_last_modified {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/last-modified/{path:.*}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub get_repository_participants {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/participants', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub get_groups_with_any_repository_permission {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/permissions/groups', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub set_repository_permission_for_group {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/permissions/groups', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'PUT', url => $url, $data ? (data => $data) : ());
}


sub revoke_repository_permissions_for_group {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/permissions/groups', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'DELETE', url => $url, $data ? (data => $data) : ());
}


sub get_groups_without_any_repository_permission {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/permissions/groups/none', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub get_users_with_any_repository_permission {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/permissions/users', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub set_repository_permission_for_user {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/permissions/users', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'PUT', url => $url, $data ? (data => $data) : ());
}


sub revoke_repository_permissions_for_user {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/permissions/users', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'DELETE', url => $url, $data ? (data => $data) : ());
}


sub get_users_without_repository_permission {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/permissions/users/none', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub create_pull_request {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub get_pull_requests {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub get_pull_request {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub update_pull_request {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'PUT', url => $url, $data ? (data => $data) : ());
}


sub delete_pull_request {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'DELETE', url => $url, $data ? (data => $data) : ());
}


sub get_pull_request_activities {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/activities', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub approve_pull_request {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/approve', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub withdraw_pull_request_approval {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/approve', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'DELETE', url => $url, $data ? (data => $data) : ());
}


sub stream_pull_request_changes {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/changes', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub get_pull_request_comments {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/comments', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub create_pull_request_comment {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/comments', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub get_pull_request_comment {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/comments/{commentId}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub delete_pull_request_comment {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/comments/{commentId}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'DELETE', url => $url, $data ? (data => $data) : ());
}


sub update_pull_request_comment {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/comments/{commentId}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'PUT', url => $url, $data ? (data => $data) : ());
}


sub get_pull_request_commits {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/commits', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub decline_pull_request {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/decline', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub stream_pull_request_diff {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/diff/{path:.*}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub merge_pull_request {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/merge', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub can_merge_pull_request {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/merge', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub get_pull_request_participants {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/participants', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub assign_participant_role {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/participants', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub unassign_participant_role {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/participants/{userSlug}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'DELETE', url => $url, $data ? (data => $data) : ());
}


sub update_status {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/participants/{userSlug}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'PUT', url => $url, $data ? (data => $data) : ());
}


sub reopen_pull_request {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/reopen', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub get_pull_request_tasks {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/tasks', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub count_pull_request_tasks {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/tasks/count', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub watch_pull_request {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/watch', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub unwatch_pull_request {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/watch', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'DELETE', url => $url, $data ? (data => $data) : ());
}


sub get_content {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/raw/{path:.*}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub retry_create_repository {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/recreate', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub get_related_repositories {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/related', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub get_repository_hooks {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/hooks', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub get_repository_hook {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/hooks/{hookKey}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub delete_repository_hook {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/hooks/{hookKey}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'DELETE', url => $url, $data ? (data => $data) : ());
}


sub enable_repository_hook {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/hooks/{hookKey}/enabled', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'PUT', url => $url, $data ? (data => $data) : ());
}


sub disable_repository_hook {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/hooks/{hookKey}/enabled', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'DELETE', url => $url, $data ? (data => $data) : ());
}


sub get_repository_hook_settings {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/hooks/{hookKey}/settings', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub set_repository_hook_settings {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/hooks/{hookKey}/settings', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'PUT', url => $url, $data ? (data => $data) : ());
}


sub update_repository_pull_request_settings {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/pull-requests', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub get_repository_pull_request_settings {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/pull-requests', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub get_tags {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/tags', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub create_tag {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/tags', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub get_tag {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/tags/{name:.*}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub watch_repository {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/watch', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub unwatch_repository {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/watch', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'DELETE', url => $url, $data ? (data => $data) : ());
}


sub create_webhook {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub find_webhooks {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub test_webhook {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks/test', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub delete_webhook {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks/{webhookId}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'DELETE', url => $url, $data ? (data => $data) : ());
}


sub get_webhook {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks/{webhookId}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub update_webhook {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks/{webhookId}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'PUT', url => $url, $data ? (data => $data) : ());
}


sub get_latest_webhook_invocation {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks/{webhookId}/latest', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub get_webhook_statistics {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks/{webhookId}/statistics', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub get_webhook_statistics_summary {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks/{webhookId}/statistics/summary', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub get_repository_hooks_for_project {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/settings/hooks', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub get_repository_hook_for_project {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/settings/hooks/{hookKey}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub enable_repository_hook_for_project {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/settings/hooks/{hookKey}/enabled', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'PUT', url => $url, $data ? (data => $data) : ());
}


sub disable_repository_hook_for_project {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/settings/hooks/{hookKey}/enabled', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'DELETE', url => $url, $data ? (data => $data) : ());
}


sub get_repository_hook_settings_for_project {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/settings/hooks/{hookKey}/settings', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub set_repository_hook_settings_for_project {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/settings/hooks/{hookKey}/settings', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'PUT', url => $url, $data ? (data => $data) : ());
}


sub update_project_pull_request_settings {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/settings/pull-requests/{scmId}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub get_project_pull_request_settings {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/projects/{projectKey}/settings/pull-requests/{scmId}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub find_repositories {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/repos', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub create_task {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/tasks', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub get_task {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/tasks/{taskId}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub delete_task {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/tasks/{taskId}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'DELETE', url => $url, $data ? (data => $data) : ());
}


sub update_task {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/tasks/{taskId}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'PUT', url => $url, $data ? (data => $data) : ());
}


sub find_users {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/users', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub update_current_user {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/users', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'PUT', url => $url, $data ? (data => $data) : ());
}


sub update_current_user_password {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/users/credentials', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'PUT', url => $url, $data ? (data => $data) : ());
}


sub get_user {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/users/{userSlug}', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub delete_user_avatar {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/users/{userSlug}/avatar.png', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'DELETE', url => $url, $data ? (data => $data) : ());
}


sub upload_user_avatar {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/users/{userSlug}/avatar.png', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub get_user_settings {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/users/{userSlug}/settings', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub update_user_settings {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('api/1.0/users/{userSlug}/settings', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::BitbucketServer::Core::V1 - Bindings for a Bitbucket Server REST API

=head1 VERSION

version 0.605

=head1 SYNOPSIS

    my $stash = WebService::BitbucketServer->new(
        base_url    => 'https://stash.example.com/',
        username    => 'bob',
        password    => 'secret',
    );
    my $api = $stash->core;

=head1 DESCRIPTION

This is a Bitbucket Server REST API for L<Core::V1|https://developer.atlassian.com/static/rest/bitbucket-server/5.10.0/bitbucket-rest.html>.

Original API documentation created by and copyright Atlassian.

=head1 ATTRIBUTES

=head2 context

Get the instance of L<WebService::BitbucketServer> passed to L</new>.

=head1 METHODS

=head2 new

    $api = WebService::BitbucketServer::Core::V1->new(context => $webservice_bitbucketserver_obj);

Create a new API.

Normally you would use C<<< $webservice_bitbucketserver_obj->core >>> instead.

=head2 get_cluster_information

Gets information about the nodes that currently make up the stash cluster.

The authenticated user must have the B<<< SYS_ADMIN >>> permission to call this resource.

    GET api/1.0/admin/cluster

Responses:

=over 4

=item * C<<< 200 >>> - data, type: application/json

Information about the cluster

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to
retrieve the cluster information.

=back

=head2 get_groups

Retrieve a page of groups.

The authenticated user must have B<<< LICENSED_USER >>> permission or higher to call this resource.

    GET api/1.0/admin/groups

Parameters:

=over 4

=item * C<<< filter >>> - string, default: none

if specified only group names containing the supplied string will be returned

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of groups.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user is not a licensed user.

=back

=head2 create_group

Create a new group.

The authenticated user must have B<<< ADMIN >>> permission or higher to call this resource.

    POST api/1.0/admin/groups

Parameters:

=over 4

=item * C<<< name >>> - string, default: none

Name of the group.

=back

Responses:

=over 4

=item * C<<< 200 >>> - restDetailedGroup, type: application/json

The newly created group.

=item * C<<< 400 >>> - errors, type: application/json

The request was malformed.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user is not an administrator.

=item * C<<< 409 >>> - errors, type: application/json

A group with this name already exists.

=back

=head2 delete_group

Deletes the specified group, removing them from the system. This also removes any permissions that may have been
granted to the group.

A user may not delete the last group that is granting them administrative permissions, or a group with greater
permissions than themselves.

The authenticated user must have the B<<< ADMIN >>> permission to call this resource.

    DELETE api/1.0/admin/groups

Parameters:

=over 4

=item * C<<< name >>> - string, default: none

the name identifying the group to delete

=back

Responses:

=over 4

=item * C<<< 200 >>> - detailedGroup, type: application/json

The deleted group.

=item * C<<< 400 >>> - errors, type: application/json

The request was malformed.

=item * C<<< 401 >>> - errors, type: application/json

The authenticated user does not have the B<<< ADMIN >>> permission.

=item * C<<< 403 >>> - errors, type: application/json

The action was disallowed as the authenticated user has a lower permission level
than the group being deleted.

=item * C<<< 404 >>> - errors, type: application/json

The specified group does not exist.

=item * C<<< 409 >>> - errors, type: application/json

The action was disallowed as it would lower the authenticated user's permission
level.

=back

=head2 add_user_to_group

B<<< Deprecated since 2.10 >>>. Use /rest/users/add-groups instead.

Add a user to a group.

In the request entity, the I<<< context >>> attribute is the group and the I<<< itemName >>> is the user.

The authenticated user must have the B<<< ADMIN >>> permission to call this resource.

    POST api/1.0/admin/groups/add-user

Responses:

=over 4

=item * C<<< 200 >>> - data, type: unknown

The user was added to the group

=item * C<<< 401 >>> - errors, type: application/json

The authenticated user does not have the B<<< ADMIN >>> permission.

=item * C<<< 403 >>> - errors, type: application/json

The action was disallowed as it would exceed the server's licensing limit, or
the groups permissions exceed the authenticated user's permission level.

=item * C<<< 404 >>> - errors, type: application/json

The specified user or group does not exist.

=back

=head2 add_users_to_group

Add multiple users to a group.

The authenticated user must have the B<<< ADMIN >>> permission to call this resource.

    POST api/1.0/admin/groups/add-users

Responses:

=over 4

=item * C<<< 200 >>> - data, type: unknown

<em>>All</em the users were added to the group

=item * C<<< 401 >>> - errors, type: application/json

The authenticated user does not have the B<<< ADMIN >>> permission.

=item * C<<< 403 >>> - errors, type: application/json

The action was disallowed as it would exceed the server's licensing limit, or
the group's permissions exceed the authenticated user's permission level.

=item * C<<< 404 >>> - errors, type: application/json

The specified group or users do not exist.

=back

=head2 find_users_in_group

Retrieves a list of users that are members of a specified group.

The authenticated user must have the B<<< LICENSED_USER >>> permission to call this resource.

    GET api/1.0/admin/groups/more-members

Parameters:

=over 4

=item * C<<< context >>> - string, default: none

the group which should be used to locate members

=item * C<<< filter >>> - string, default: none

if specified only users with usernames, display names or email addresses containing the
supplied string will be returned

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of users.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user is not a licensed user.

=back

=head2 find_users_not_in_group

Retrieves a list of users that are I<<< not >>> members of a specified group.

The authenticated user must have the B<<< LICENSED_USER >>> permission to call this resource.

    GET api/1.0/admin/groups/more-non-members

Parameters:

=over 4

=item * C<<< context >>> - string, default: none

the group which should be used to locate non-members

=item * C<<< filter >>> - string, default: none

if specified only users with usernames, display names or email addresses containing the
supplied string will be returned

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of users.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user is not a licensed user.

=back

=head2 remove_user_from_group

B<<< Deprecated since 2.10 >>>. Use /rest/users/remove-groups instead.

Remove a user from a group.

The authenticated user must have the B<<< ADMIN >>> permission to call this resource.

In the request entity, the I<<< context >>> attribute is the group and the I<<< itemName >>> is the user.

    POST api/1.0/admin/groups/remove-user

Responses:

=over 4

=item * C<<< 200 >>> - data, type: unknown

The user was removed from the group.

=item * C<<< 401 >>> - errors, type: application/json

The authenticated user does not have the B<<< ADMIN >>> permission.

=item * C<<< 403 >>> - errors, type: application/json

The action was disallowed as the group has a higher permission level than the
context user.

=item * C<<< 404 >>> - errors, type: application/json

The specified user or group does not exist.

=back

=head2 get_license

Retrieves details about the current license, as well as the current status of the system with regards to the
installed license. The status includes the current number of users applied toward the license limit, as well
as any status messages about the license (warnings about expiry or user counts exceeding license limits).

The authenticated user must have B<<< ADMIN >>> permission. Unauthenticated users, and non-administrators, are
not permitted to access license details.

    GET api/1.0/admin/license

Responses:

=over 4

=item * C<<< 200 >>> - license, type: application/json

The currently-installed license.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to view the
license, or the request is anonymous.

=item * C<<< 404 >>> - errors, type: application/json

No license has been installed.

=back

=head2 update_license

Decodes the provided encoded license and sets it as the active license. If no license was provided, a 400 is
returned. If the license cannot be decoded, or cannot be applied, a 409 is returned. Some possible reasons a
license may not be applied include:

=over 4

=item *

It is for a different product

=item *

It is already expired

=back

Otherwise, if the license is updated successfully, details for the new license are returned with a 200 response.

B<<< Warning >>>: It is possible to downgrade the license during update, applying a license with a lower number
of permitted users. If the number of currently-licensed users exceeds the limits of the new license, pushing
will be disabled until the licensed user count is brought into compliance with the new license.

The authenticated user must have B<<< SYS_ADMIN >>> permission. B<<< ADMIN >>> users may I<<< view >>> the current
license details, but they may not I<<< update >>> the license.

    POST api/1.0/admin/license

Responses:

=over 4

=item * C<<< 200 >>> - license, type: application/json

The newly-installed license.

=item * C<<< 400 >>> - errors, type: application/json

No encoded license was provided in the JSON body for the POST.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to update the
license.

=item * C<<< 409 >>> - errors, type: application/json

The encoded license could not be decoded, or it is not valid for use on this
server. For example, it may be for a different product, or it may have already
expired.

=back

=head2 delete_mail_config

Deletes the current mail configuration.

The authenticated user must have the B<<< SYS_ADMIN >>> permission to call this resource.

    DELETE api/1.0/admin/mail-server

Responses:

=over 4

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to
delete the mail server configuration.

=item * C<<< 204 >>> - data, type: application/json

The mail configuration was successfully deleted.

=back

=head2 get_mail_config

Retrieves the current mail configuration.
The authenticated user must have the B<<< SYS_ADMIN >>> permission to call this resource.

    GET api/1.0/admin/mail-server

Responses:

=over 4

=item * C<<< 200 >>> - mailHostConfiguration, type: application/json

The mail configuration.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to retrieve the
mail configuration.

=item * C<<< 404 >>> - data, type: application/json

The mail server hasn't been configured

=back

=head2 set_mail_config

Updates the mail configuration
The authenticated user must have the B<<< SYS_ADMIN >>> permission to call this resource.

    PUT api/1.0/admin/mail-server

Responses:

=over 4

=item * C<<< 200 >>> - mailConfiguration, type: application/json

The updated mail configuration.

=item * C<<< 400 >>> - errors, type: application/json

The mail configuration was not updated due to a validation error.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to update the
mail configuration.

=back

=head2 clear_sender_address

Clears the server email address.

The authenticated user must have the B<<< ADMIN >>> permission to call this resource.

    DELETE api/1.0/admin/mail-server/sender-address

Responses:

=over 4

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to
clear the server email address.

=item * C<<< 204 >>> - data, type: application/json

The server email address was successfully cleared.

=back

=head2 get_sender_address

Retrieves the server email address

    GET api/1.0/admin/mail-server/sender-address

Responses:

=over 4

=item * C<<< 200 >>> - server email address, type: application/json

The server email address

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to retrieve the
server email address.

=item * C<<< 404 >>> - data, type: application/json

The server email address is not set

=back

=head2 set_sender_address

Updates the server email address
The authenticated user must have the B<<< ADMIN >>> permission to call this resource.

    PUT api/1.0/admin/mail-server/sender-address

Responses:

=over 4

=item * C<<< 200 >>> - senderAddress, type: application/json

The updated server email address.

=item * C<<< 400 >>> - errors, type: application/json

The server email address was not updated due to a validation error.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to update the
server email address.

=back

=head2 set_permission_for_groups

Promote or demote a user's global permission level. Available global permissions are:

=over 4

=item *

LICENSED_USER

=item *

PROJECT_CREATE

=item *

ADMIN

=item *

SYS_ADMIN

=back

See the L<<< Bitbucket Server
documentation|https://confluence.atlassian.com/display/BitbucketServer/Global+permissions >>> for a detailed explanation of what each permission entails.

The authenticated user must have:

=over 4

=item *

B<<< ADMIN >>> permission or higher; and

=item *

the permission they are attempting to grant or higher; and

=item *

greater or equal permissions than the current permission level of the group (a user may not demote the
permission level of a group with higher permissions than them)

=back

to call this resource. In addition, a user may not demote a group's permission level if their own permission
level would be reduced as a result.

    PUT api/1.0/admin/permissions/groups

Parameters:

=over 4

=item * C<<< permission >>> - string, default: none

the permission to grant

=item * C<<< name >>> - string, default: none

the names of the groups

=back

Responses:

=over 4

=item * C<<< 400 >>> - errors, type: application/json

The request was malformed or the specified permission does not exist.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user is not an administrator or doesn't have the
specified permission they are attempting to grant.

=item * C<<< 204 >>> - data, type: unknown

The specified permission was granted to the specified user.

=item * C<<< 403 >>> - errors, type: application/json

The action was disallowed as it would exceed the server's license limits.

=item * C<<< 404 >>> - errors, type: application/json

The specified group does not exist.

=item * C<<< 409 >>> - errors, type: application/json

The action was disallowed as it would reduce the currently authenticated user's
permission level or the currently authenticated user has a lower permission
level than the group they are attempting to modify.

=back

=head2 get_groups_with_any_permission

Retrieve a page of groups that have been granted at least one global permission.

The authenticated user must have B<<< ADMIN >>> permission or higher to call this resource.

    GET api/1.0/admin/permissions/groups

Parameters:

=over 4

=item * C<<< filter >>> - string, default: none

if specified only group names containing the supplied string will be returned

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of groups and their highest global permissions.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user is not an administrator.

=back

=head2 revoke_permissions_for_group

Revoke all global permissions for a group.

The authenticated user must have:

=over 4

=item *

B<<< ADMIN >>> permission or higher; and

=item *

greater or equal permissions than the current permission level of the group (a user may not demote the
permission level of a group with higher permissions than them)

=back

to call this resource. In addition, a user may not revoke a group's permissions if their own permission level
would be reduced as a result.

    DELETE api/1.0/admin/permissions/groups

Parameters:

=over 4

=item * C<<< name >>> - string, default: none

the name of the group

=back

Responses:

=over 4

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user is not an administrator.

=item * C<<< 204 >>> - data, type: unknown

All global permissions were revoked from the group.

=item * C<<< 404 >>> - errors, type: application/json

The specified group does not exist.

=item * C<<< 409 >>> - errors, type: application/json

The action was disallowed as it would reduce the currently authenticated user's
permission level or the currently authenticated user has a lower permission
level than the group they are attempting to modify.

=back

=head2 get_groups_without_any_permission

Retrieve a page of groups that have no granted global permissions.

The authenticated user must have B<<< ADMIN >>> permission or higher to call this resource.

    GET api/1.0/admin/permissions/groups/none

Parameters:

=over 4

=item * C<<< filter >>> - string, default: none

if specified only group names containing the supplied string will be returned

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of groups that have not been granted any global permissions.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user is not an administrator.

=back

=head2 set_permission_for_users

Promote or demote the global permission level of a user. Available global permissions are:

=over 4

=item *

LICENSED_USER

=item *

PROJECT_CREATE

=item *

ADMIN

=item *

SYS_ADMIN

=back

See the L<<< Bitbucket Server
documentation|https://confluence.atlassian.com/display/BitbucketServer/Global+permissions >>> for a detailed explanation of what each permission entails.

The authenticated user must have:

=over 4

=item *

B<<< ADMIN >>> permission or higher; and

=item *

the permission they are attempting to grant; and

=item *

greater or equal permissions than the current permission level of the user (a user may not demote the
permission level of a user with higher permissions than them)

=back

to call this resource. In addition, a user may not demote their own permission level.

    PUT api/1.0/admin/permissions/users

Parameters:

=over 4

=item * C<<< name >>> - string, default: none

the names of the users

=item * C<<< permission >>> - string, default: none

the permission to grant

=back

Responses:

=over 4

=item * C<<< 400 >>> - errors, type: application/json

The request was malformed or the specified permission does not exist.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user is not an administrator or doesn't have the
specified permission they are attempting to grant.

=item * C<<< 204 >>> - data, type: unknown

The requested permission was granted.

=item * C<<< 403 >>> - errors, type: application/json

The action was disallowed as it would exceed the server's license limits.

=item * C<<< 404 >>> - errors, type: application/json

The specified user does not exist.

=item * C<<< 409 >>> - errors, type: application/json

The action was disallowed as it would reduce the currently authenticated user's
permission level or the currently authenticated user has a lower permission
level than the user they are attempting to modify.

=back

=head2 get_users_with_any_permission

Retrieve a page of users that have been granted at least one global permission.

The authenticated user must have B<<< ADMIN >>> permission or higher to call this resource.

    GET api/1.0/admin/permissions/users

Parameters:

=over 4

=item * C<<< filter >>> - string, default: none

if specified only user names containing the supplied string will be returned

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of users and their highest global permissions.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user is not an administrator.

=back

=head2 revoke_permissions_for_user

Revoke all global permissions for a user.

The authenticated user must have:

=over 4

=item *

B<<< ADMIN >>> permission or higher; and

=item *

greater or equal permissions than the current permission level of the user (a user may not demote the
permission level of a user with higher permissions than them)

=back

to call this resource. In addition, a user may not demote their own permission level.

    DELETE api/1.0/admin/permissions/users

Parameters:

=over 4

=item * C<<< name >>> - string, default: none

the name of the user

=back

Responses:

=over 4

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user is not an administrator.

=item * C<<< 204 >>> - data, type: unknown

All global permissions were revoked from the user.

=item * C<<< 404 >>> - errors, type: application/json

The specified user does not exist.

=item * C<<< 409 >>> - errors, type: application/json

The action was disallowed as it would reduce the currently authenticated user's
permission level or the currently authenticated user has a lower permission
level than the user they are attempting to modify.

=back

=head2 get_users_without_any_permission

Retrieve a page of users that have no granted global permissions.

The authenticated user must have B<<< ADMIN >>> permission or higher to call this resource.

    GET api/1.0/admin/permissions/users/none

Parameters:

=over 4

=item * C<<< filter >>> - string, default: none

if specified only user names containing the supplied string will be returned

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of users that have not been granted any global permissions.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user is not an administrator.

=back

=head2 set_merge_config

Update the pull request merge strategies for the context repository.

The authenticated user must have B<<< ADMIN >>> permission for the context repository to call this
resource.

Only the strategies provided will be enabled, only one may be set to default

An explicitly set pull request merge strategy configuration can be deleted by POSTing a document with
an empty "mergeConfig" attribute. i.e:

    {
       "mergeConfig" : {}
    }

Upon completion of this request, the effective configuration will be the default configuration.

    POST api/1.0/admin/pull-requests/{scmId}

Parameters:

=over 4

=item * C<<< scmId >>> - string, default: none

the id of the scm to get strategies for

=back

Responses:

=over 4

=item * C<<< 200 >>> - strategies, type: application/json

The repository pull request merge strategies for the context repository.

=item * C<<< 400 >>> - errors, type: application/json

The repository pull request merge strategies were not updated due to a validation error.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to administrate the
specified repository.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository does not exist.

=back

=head2 get_merge_config

Retrieve the merge strategies available for this instance.

The user must be authenticated to call this resource.

    GET api/1.0/admin/pull-requests/{scmId}

Parameters:

=over 4

=item * C<<< scmId >>> - string, default: none

the id of the scm to get strategies for

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

The merge configuration of this instance.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to see the
request repository.

=item * C<<< 404 >>> - errors, type: application/json

The request repository does not exist.

=back

=head2 get_users

Retrieve a page of users.

The authenticated user must have the B<<< LICENSED_USER >>> permission to call this resource.

    GET api/1.0/admin/users

Parameters:

=over 4

=item * C<<< filter >>> - string, default: none

if specified only users with usernames, display name or email addresses containing the supplied
string will be returned

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of users.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user is not a licensed user.

=back

=head2 update_user_details

Update a user's details.

The authenticated user must have the B<<< ADMIN >>> permission to call this resource.

    PUT api/1.0/admin/users

Responses:

=over 4

=item * C<<< 200 >>> - detailedUser, type: application/json

The updated user.

=item * C<<< 400 >>> - errors, type: application/json

The request was malformed.

=item * C<<< 401 >>> - errors, type: application/json

The authenticated user does not have the B<<< ADMIN >>> permission or
has a lower permission level than the user being deleted.

=item * C<<< 404 >>> - errors, type: application/json

The specified user does not exist.

=back

=head2 create_user

Creates a new user from the assembled query parameters.

The default group can be used to control initial permissions for new users, such as granting users the ability
to login or providing read access to certain projects or repositories. If the user is not added to the default
group, they may not be able to login after their account is created until explicit permissions are configured.

The authenticated user must have the B<<< ADMIN >>> permission to call this resource.

    POST api/1.0/admin/users

Parameters:

=over 4

=item * C<<< name >>> - string, default: none

the username for the new user

=item * C<<< password >>> - string, default: none

the password for the new user

=item * C<<< displayName >>> - string, default: none

the display name for the new user

=item * C<<< emailAddress >>> - string, default: none

the e-mail address for the new user

=item * C<<< addToDefaultGroup >>> - boolean, default: true

C<<< true >>> to add the user to the default group, which can be used to grant them
a set of initial permissions; otherwise, C<<< false >>> to not add them to a group

=item * C<<< notify >>> - string, default: none

if present and not C<<< false >>> instead of requiring a password,
the create user will be notified via email their account has been created and requires
a password to be reset. This option can only be used if a mail server has been configured

=back

Responses:

=over 4

=item * C<<< 400 >>> - errors, type: application/json

The request was malformed.

=item * C<<< 401 >>> - errors, type: application/json

The authenticated user is not an administrator.

=item * C<<< 204 >>> - data, type: unknown

The user was successfully created.

=item * C<<< 403 >>> - errors, type: application/json

Adding the user to the default group would exceed the server's license limit.

=item * C<<< 409 >>> - errors, type: application/json

Another user with the same name already exists.

=back

=head2 delete_user

Deletes the specified user, removing them from the system. This also removes any permissions that may have been
granted to the user.

A user may not delete themselves, and a user with B<<< ADMIN >>> permissions may not delete a user with
B<<< SYS_ADMIN >>>permissions.

The authenticated user must have the B<<< ADMIN >>> permission to call this resource.

    DELETE api/1.0/admin/users

Parameters:

=over 4

=item * C<<< name >>> - string, default: none

the username identifying the user to delete

=back

Responses:

=over 4

=item * C<<< 200 >>> - detailedUser, type: application/json

The deleted user.

=item * C<<< 400 >>> - errors, type: application/json

The request was malformed.

=item * C<<< 401 >>> - errors, type: application/json

The authenticated user does not have the B<<< ADMIN >>> permission.

=item * C<<< 403 >>> - errors, type: application/json

The action was disallowed as the authenticated user has a lower permission level
than the user being deleted.

=item * C<<< 404 >>> - errors, type: application/json

The specified user does not exist.

=item * C<<< 409 >>> - errors, type: application/json

The action was disallowed as a user can not delete themselves.

=back

=head2 add_group_to_user

B<<< Deprecated since 2.10 >>>. Use /rest/users/add-groups instead.

Add a user to a group. This is very similar to C<<< groups/add-user >>>, but with the I<<< context >>> and
I<<< itemName >>> attributes of the supplied request entity reversed. On the face of it this may appear
redundant, but it facilitates a specific UI component in Stash.

In the request entity, the I<<< context >>> attribute is the user and the I<<< itemName >>> is the group.

The authenticated user must have the B<<< ADMIN >>> permission to call this resource.

    POST api/1.0/admin/users/add-group

Responses:

=over 4

=item * C<<< 200 >>> - data, type: unknown

The user was added to the group

=item * C<<< 401 >>> - errors, type: application/json

The authenticated user does not have the B<<< ADMIN >>> permission.

=item * C<<< 403 >>> - errors, type: application/json

The action was disallowed as it would exceed the server's licensing limit, or
the groups permissions exceed the authenticated user's permission level.

=item * C<<< 404 >>> - errors, type: application/json

The specified user or group does not exist.

=back

=head2 add_user_to_groups

Add a user to one or more groups.

The authenticated user must have the B<<< ADMIN >>> permission to call this resource.

    POST api/1.0/admin/users/add-groups

Responses:

=over 4

=item * C<<< 200 >>> - data, type: unknown

The user was added to I<<< all >>> the groups

=item * C<<< 401 >>> - errors, type: application/json

The authenticated user does not have the B<<< ADMIN >>> permission.

=item * C<<< 403 >>> - errors, type: application/json

The action was disallowed as it would exceed the server's licensing limit, or
the groups permissions exceed the authenticated user's permission level.

=item * C<<< 404 >>> - errors, type: application/json

The specified user or groups do not exist.

=back

=head2 clear_user_captcha_challenge

Clears any CAPTCHA challenge that may constrain the user with the supplied username when they authenticate.
Additionally any counter or metric that contributed towards the user being issued the CAPTCHA challenge
(for instance too many consecutive failed logins) will also be reset.

The authenticated user must have the B<<< ADMIN >>> permission to call this resource, and may not clear
the CAPTCHA of a user with greater permissions than themselves.

    DELETE api/1.0/admin/users/captcha

Parameters:

=over 4

=item * C<<< name >>> - string, default: none

=back

Responses:

=over 4

=item * C<<< 400 >>> - errors, type: application/json

The request was malformed.

=item * C<<< 401 >>> - errors, type: application/json

The authenticated user does not have the B<<< ADMIN >>> permission.

=item * C<<< 204 >>> - data, type: application/json

The CAPTCHA was successfully cleared.

=item * C<<< 403 >>> - errors, type: application/json

The action was disallowed as the authenticated user has a lower permission level
than the group being deleted.

=item * C<<< 404 >>> - errors, type: application/json

The specified user does not exist.

=back

=head2 update_user_password

Update a user's password.

The authenticated user must have the B<<< ADMIN >>> permission to call this resource, and may not update
the password of a user with greater permissions than themselves.

    PUT api/1.0/admin/users/credentials

Responses:

=over 4

=item * C<<< 400 >>> - errors, type: application/json

The request was malformed.

=item * C<<< 401 >>> - errors, type: application/json

The authenticated user does not have the B<<< ADMIN >>> permission or
has a lower permission level than the user being deleted.

=item * C<<< 204 >>> - data, type: unknown

The user's password was successfully updated.

=item * C<<< 404 >>> - errors, type: application/json

The specified user does not exist.

=back

=head2 find_groups_for_user

Retrieves a list of groups the specified user is a member of.

The authenticated user must have the B<<< LICENSED_USER >>> permission to call this resource.

    GET api/1.0/admin/users/more-members

Parameters:

=over 4

=item * C<<< context >>> - string, default: none

the user which should be used to locate groups

=item * C<<< filter >>> - string, default: none

if specified only groups with names containing the supplied string will be returned

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of groups.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user is not a licensed user.

=back

=head2 find_other_groups_for_user

Retrieves a list of groups the specified user is I<<< not >>> a member of.

The authenticated user must have the B<<< LICENSED_USER >>> permission to call this resource.

    GET api/1.0/admin/users/more-non-members

Parameters:

=over 4

=item * C<<< context >>> - string, default: none

the user which should be used to locate groups

=item * C<<< filter >>> - string, default: none

if specified only groups with names containing the supplied string will be returned

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of groups.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user is not a licensed user.

=back

=head2 remove_group_from_user

Remove a user from a group. This is very similar to C<<< groups/remove-user >>>, but with the I<<< context >>>
and I<<< itemName >>> attributes of the supplied request entity reversed. On the face of it this may appear
redundant, but it facilitates a specific UI component in Stash.

In the request entity, the I<<< context >>> attribute is the user and the I<<< itemName >>> is the group.

The authenticated user must have the B<<< ADMIN >>> permission to call this resource.

    POST api/1.0/admin/users/remove-group

Responses:

=over 4

=item * C<<< 200 >>> - data, type: unknown

The user was removed from the group.

=item * C<<< 401 >>> - errors, type: application/json

The authenticated user does not have the B<<< ADMIN >>> permission.

=item * C<<< 403 >>> - errors, type: application/json

The action was disallowed as the group has a higher permission level than the
context user.

=item * C<<< 404 >>> - errors, type: application/json

The specified user or group does not exist.

=back

=head2 rename_user

Rename a user.

The authenticated user must have the B<<< ADMIN >>> permission to call this resource.

    POST api/1.0/admin/users/rename

Responses:

=over 4

=item * C<<< 200 >>> - detailedUser, type: application/json

The renamed user.

=item * C<<< 400 >>> - errors, type: application/json

The request was malformed.

=item * C<<< 401 >>> - errors, type: application/json

The authenticated user does not have the B<<< ADMIN >>> permission or
has a lower permission level than the user being deleted.

=item * C<<< 404 >>> - errors, type: application/json

The specified user does not exist.

=back

=head2 get_application_properties

Retrieve version information and other application properties.

No authentication is required to call this resource.

    GET api/1.0/application-properties

Responses:

=over 4

=item * C<<< 200 >>> - applicationProperties, type: application/json

The application properties.

=back

=head2 get_dashboard_pull_request_suggestions

Retrieves a page of suggestions for pull requests that the currently authenticated user may wish to
raise. Such suggestions are based on ref changes occurring and so contain the ref change that
prompted the suggestion plus the time the change event occurred. Changes will be returned in
descending order based on the time the change that prompted the suggestion occurred.

Note that although the response is a page object, the interface does not support paging, however
a limit can be applied to the size of the returned page.

    GET api/1.0/dashboard/pull-request-suggestions

Parameters:

=over 4

=item * C<<< changesSince >>> - string, default: 172800

restrict pull request suggestions to be based on events that occurred since some time
in the past. This is expressed in seconds since "now". So to return suggestions
based only on activity within the past 48 hours, pass a value of 172800.

=item * C<<< limit >>> - int, default: 3

restricts the result set to return at most this many suggestions.

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of pull requests that match the search criteria.

=item * C<<< 400 >>> - errors, type: application/json

The request was malformed.

=item * C<<< 401 >>> - errors, type: application/json

The current user is not authenticated

=back

=head2 get_dashboard_pull_requests

Retrieve a page of pull requests where the current authenticated user is involved as either a reviewer, author
or a participant. The request may be filtered by pull request state, role or participant status.

    GET api/1.0/dashboard/pull-requests

Parameters:

=over 4

=item * C<<< state >>> - string, default: none

(optional, defaults to returning pull requests in any state). If a state is supplied only pull
requests in the specified state will be returned. Either B<<< OPEN >>>,
B<<< DECLINED >>> or B<<< MERGED >>>.
Omit this parameter to return pull request in any state.

=item * C<<< role >>> - string, default: none

(optional, defaults to returning pull requests for any role). If a role is supplied only pull
requests where the authenticated user is a participant in the given role will be returned.
Either B<<< REVIEWER >>>, B<<< AUTHOR >>> or B<<< PARTICIPANT >>>.

=item * C<<< participantStatus >>> - string, default: none

(optional, defaults to returning pull requests with any participant status). A comma
separated list of participant status. That is, one or more of
B<<< UNAPPROVED >>>, B<<< NEEDS_WORK >>>, or B<<< APPROVED >>>.

=item * C<<< order >>> - string, default: none

(optional, defaults to B<<< NEWEST >>>) the order to return pull requests in, either
B<<< OLDEST >>> (as in: "oldest first"), B<<< NEWEST >>>,
B<<< PARTICIPANT_STATUS >>>, or B<<< CLOSED_DATE >>>. Where
B<<< CLOSED_DATE >>> is specified and the result set includes pull requests that are not in
the closed state, these pull requests will appear first in the result set, followed by most recently
closed pull requests.

=item * C<<< closedSince >>> - string, default: none

(optional, defaults to returning pull requests regardless of closed since date). Permits
returning only pull requests with a closed timestamp set more recently that
(now - closedSince). Units are in seconds. So for example if closed since 86400 is set only
pull requests closed in the previous 24 hours will be returned.

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of pull requests that match the search criteria.

=item * C<<< 400 >>> - errors, type: application/json

The request was malformed.

=item * C<<< 401 >>> - errors, type: application/json

The current user is not authenticated

=back

=head2 get_group_names

Retrieve a page of group names.

The authenticated user must have B<<< PROJECT_ADMIN >>> permission or higher to call this resource.

    GET api/1.0/groups

Parameters:

=over 4

=item * C<<< filter >>> - string, default: none

if specified only group names containing the supplied string will be returned

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of group names.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user is not a project administrator.

=back

=head2 get_avatar

Retrieve the avatar for the project matching the supplied B<<< moduleKey >>>.

    GET api/1.0/hooks/{hookKey}/avatar

Parameters:

=over 4

=item * C<<< hookKey >>> - string, default: none

the complete module key of the hook module

=item * C<<< version >>> - string, default: none

optional version used for HTTP caching only - any non-blank version will result in a large max-age Cache-Control header.
Note that this does not affect the Last-Modified header.

=back

Responses:

=over 4

=item * C<<< 200 >>> - data, type: image/png

The avatar of the project matching the supplied B<<< projectKey >>>.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to view the
project.

=item * C<<< 404 >>> - errors, type: application/json

The specified project does not exist.

=back

=head2 get_inbox_pull_requests

    GET api/1.0/inbox/pull-requests

Parameters:

=over 4

=item * C<<< start >>> - int, default: none

=item * C<<< limit >>> - int, default: 25

=item * C<<< role >>> - string, default: reviewer

=back

=head2 get_inbox_pull_request_count

    GET api/1.0/inbox/pull-requests/count

=head2 get_level

Retrieve the current log level for a given logger.

The authenticated user must have B<<< ADMIN >>> permission or higher to call this resource.

    GET api/1.0/logs/logger/{loggerName}

Parameters:

=over 4

=item * C<<< loggerName >>> - string, default: none

the name of the logger.

=back

Responses:

=over 4

=item * C<<< 200 >>> - logLevel, type: application/json

The log level of the logger.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions
to retrieve the log level.

=back

=head2 set_level

Set the current log level for a given logger.

The authenticated user must have B<<< ADMIN >>> permission or higher to call this resource.

    PUT api/1.0/logs/logger/{loggerName}/{levelName}

Parameters:

=over 4

=item * C<<< levelName >>> - string, default: none

the level to set the logger to. Either TRACE, DEBUG, INFO, WARN or ERROR

=item * C<<< loggerName >>> - string, default: none

the name of the logger.

=back

Responses:

=over 4

=item * C<<< 400 >>> - errors, type: application/json

The log level was invalid.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions
to set the log level.

=item * C<<< 204 >>> - data, type: application/json

The log level was successfully changed.

=back

=head2 get_root_level

Retrieve the current log level for the root logger.

The authenticated user must have B<<< ADMIN >>> permission or higher to call this resource.

    GET api/1.0/logs/rootLogger

Responses:

=over 4

=item * C<<< 200 >>> - logLevel, type: application/json

The log level of the logger.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions
to retrieve the log level.

=back

=head2 set_root_level

Set the current log level for the root logger.

The authenticated user must have B<<< ADMIN >>> permission or higher to call this resource.

    PUT api/1.0/logs/rootLogger/{levelName}

Parameters:

=over 4

=item * C<<< levelName >>> - string, default: none

the level to set the logger to. Either TRACE, DEBUG, INFO, WARN or ERROR

=back

Responses:

=over 4

=item * C<<< 400 >>> - errors, type: application/json

The log level was invalid.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions
to retrieve the log level.

=item * C<<< 204 >>> - data, type: application/json

The log level was successfully changed.

=back

=head2 preview

Preview the generated html for given markdown contents.

Only authenticated users may call this resource.

    POST api/1.0/markup/preview

Parameters:

=over 4

=item * C<<< urlMode >>> - string, default: none

(Optional) The UrlMode used when building the url. One of: ABSOLUTE, RELATIVE and CONFIGURED
By default this is RELATIVE.

=item * C<<< hardwrap >>> - boolean, default: none

(Optional) Whether the markup implementation should convert newlines to breaks.
By default this is false which reflects the standard markdown specification.

=item * C<<< htmlEscape >>> - boolean, default: none

(Optional) true if HTML should be escaped in the input markup, false otherwise.

=back

Responses:

=over 4

=item * C<<< 200 >>> - markup, type: application/json

The rendered markdown.

=item * C<<< 400 >>> - errors, type: application/json

The markdown was invalid.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions
preview rendered markdown.

=back

=head2 get_repositories_recently_accessed

Retrieve a page of recently accessed repositories for the currently authenticated user.

Repositories are ordered from most recently to least recently accessed.

Only authenticated users may call this resource.

    GET api/1.0/profile/recent/repos

Parameters:

=over 4

=item * C<<< permission >>> - string, default: none

(optional) if specified, it must be a valid repository permission level name and will limit
the resulting repository list to ones that the requesting user has the specified permission
level to. If not specified, the default C<<< REPO_READ >>> permission level will be assumed.

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of recently accessed repositories.

=item * C<<< 400 >>> - errors, type: application/json

The permission level is unknown or not related to repository.

=item * C<<< 401 >>> - errors, type: application/json

The request is unauthenticated.

=back

=head2 get_projects

Retrieve a page of projects.

Only projects for which the authenticated user has the B<<< PROJECT_VIEW >>> permission will be returned.

    GET api/1.0/projects

Parameters:

=over 4

=item * C<<< name >>> - string, default: none

=item * C<<< permission >>> - string, default: none

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of projects.

=item * C<<< 400 >>> - errors, type: application/json

The permission level is unknown or not related to projects.

=back

=head2 create_project

Create a new project.

To include a custom avatar for the project, the project definition should contain an additional attribute with
the key C<<< avatar >>> and the value a data URI containing Base64-encoded image data. The URI should be in
the following format:

    data:(content type, e.g. image/png);base64,(data)

If the data is not Base64-encoded, or if a character set is defined in the URI, or the URI is otherwise invalid,
I<<< project creation will fail >>>.

The authenticated user must have B<<< PROJECT_CREATE >>> permission to call this resource.

    POST api/1.0/projects

Responses:

=over 4

=item * C<<< 201 >>> - project, type: application/json

The newly created project.

=item * C<<< 400 >>> - errors, type: application/json

The project was not created due to a validation error.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to create a
project.

=item * C<<< 409 >>> - errors, type: application/json

The project key or name is already in use.

=back

=head2 get_project

Retrieve the project matching the supplied B<<< projectKey >>>.

The authenticated user must have B<<< PROJECT_VIEW >>> permission for the specified project to call this
resource.

    GET api/1.0/projects/{projectKey}

Responses:

=over 4

=item * C<<< 200 >>> - project, type: application/json

The project matching the supplied B<<< projectKey >>>.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to view the
project.

=item * C<<< 404 >>> - errors, type: application/json

The specified project does not exist.

=back

=head2 delete_project

Delete the project matching the supplied B<<< projectKey >>>.

The authenticated user must have B<<< PROJECT_ADMIN >>> permission for the specified project to call this
resource.

    DELETE api/1.0/projects/{projectKey}

Responses:

=over 4

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to delete the
project.

=item * C<<< 204 >>> - data, type: unknown

The project matching the supplied B<<< projectKey >>> was
deleted.

=item * C<<< 404 >>> - errors, type: application/json

The specified project does not exist.

=item * C<<< 409 >>> - errors, type: application/json

The project can not be deleted as it contains repositories.

=back

=head2 update_project

Update the project matching the B<<< projectKey >>> supplied in the resource path.

To include a custom avatar for the updated project, the project definition should contain an additional attribute
with the key C<<< avatar >>> and the value a data URI containing Base64-encoded image data. The URI should be
in the following format:
C<<<
data:(content type, e.g. image/png);base64,(data)
 >>>
If the data is not Base64-encoded, or if a character set is defined in the URI, or the URI is otherwise invalid,
I<<< project creation will fail >>>.

The authenticated user must have B<<< PROJECT_ADMIN >>> permission for the specified project to call this
resource.

    PUT api/1.0/projects/{projectKey}

Responses:

=over 4

=item * C<<< 200 >>> - project, type: application/json

The updated project. The project's key B<<< was not >>> updated.

=item * C<<< 201 >>> - project, type: application/json

The updated project. The project's key B<<< was >>> updated.

=item * C<<< 400 >>> - errors, type: application/json

The project was not updated due to a validation error.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to update the
project.

=item * C<<< 404 >>> - errors, type: application/json

The specified project does not exist.

=back

=head2 get_project_avatar

Retrieve the avatar for the project matching the supplied B<<< projectKey >>>.

The authenticated user must have B<<< PROJECT_VIEW >>> permission for the specified project to call this
resource.

    GET api/1.0/projects/{projectKey}/avatar.png

Parameters:

=over 4

=item * C<<< s >>> - int, default: none

The desired size of the image. The server will return an image as close as possible to the specified
size.

=back

Responses:

=over 4

=item * C<<< 200 >>> - data, type: image/png

The avatar of the project matching the supplied B<<< projectKey >>>.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to view the
project.

=item * C<<< 404 >>> - errors, type: application/json

The specified project does not exist.

=back

=head2 upload_project_avatar

Update the avatar for the project matching the supplied B<<< projectKey >>>.

This resource accepts POST multipart form data, containing a single image in a form-field named 'avatar'.

There are configurable server limits on both the dimensions (1024x1024 pixels by default) and uploaded file size
(1MB by default). Several different image formats are supported, but B<<< PNG >>> and
B<<< JPEG >>> are preferred due to the file size limit.

This resource has Cross-Site Request Forgery (XSRF) protection. To allow the request to
pass the XSRF check the caller needs to send an C<<< X-Atlassian-Token >>> HTTP header with the
value C<<< no-check >>>.

An example L<<< curl|http://curl.haxx.se/ >>> request to upload an image name 'avatar.png' would be:

    curl -X POST -u username:password -H "X-Atlassian-Token: no-check" http://example.com/rest/api/1.0/projects/STASH/avatar.png -F avatar=@avatar.png

The authenticated user must have B<<< PROJECT_ADMIN >>> permission for the specified project to call this
resource.

    POST api/1.0/projects/{projectKey}/avatar.png

Responses:

=over 4

=item * C<<< 201 >>> - data, type: unknown

The avatar was uploaded successfully.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to update the
project.

=item * C<<< 404 >>> - errors, type: application/json

The specified project does not exist.

=back

=head2 set_project_permission_for_groups

Promote or demote a group's permission level for the specified project.

The authenticated user must have B<<< PROJECT_ADMIN >>> permission for the specified project or a higher
global permission to call this resource. In addition, a user may not demote a group's permission level if their
own permission level would be reduced as a result.

    PUT api/1.0/projects/{projectKey}/permissions/groups

Parameters:

=over 4

=item * C<<< permission >>> - string, default: none

The permission to grant.
See the [permissions documentation](https://confluence.atlassian.com/display/BitbucketServer/Using+project+permissions)
for a detailed explanation of what each permission entails.
Available project permissions are:

=over 4

=item *

PROJECT_READ

=item *

PROJECT_WRITE

=item *

PROJECT_ADMIN

=back

=item * C<<< name >>> - string, default: none

the names of the groups

=back

Responses:

=over 4

=item * C<<< 400 >>> - errors, type: application/json

The request was malformed or the specified permission does not exist.

=item * C<<< 401 >>> - data, type: unknown

The currently authenticated user is not an administrator for the specified
project.

=item * C<<< 204 >>> - data, type: unknown

The requested permission was granted.

=item * C<<< 403 >>> - data, type: unknown

The action was disallowed as it would reduce the currently authenticated user's
permission level.

=item * C<<< 404 >>> - data, type: unknown

The specified project or group does not exist.

=back

=head2 get_groups_with_any_project_permission

Retrieve a page of groups that have been granted at least one permission for the specified project.

The authenticated user must have B<<< PROJECT_ADMIN >>> permission for the specified project or a higher
global permission to call this resource.

    GET api/1.0/projects/{projectKey}/permissions/groups

Parameters:

=over 4

=item * C<<< filter >>> - string, default: none

if specified only group names containing the supplied string will be returned

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of groups and their highest permissions for the specified project.

=item * C<<< 401 >>> - data, type: unknown

The currently authenticated user is not a project administrator for the
specified project.

=item * C<<< 404 >>> - data, type: unknown

The specified project does not exist.

=back

=head2 revoke_project_permissions_for_group

Revoke all permissions for the specified project for a group.

The authenticated user must have B<<< PROJECT_ADMIN >>> permission for the specified project or a higher
global permission to call this resource.

In addition, a user may not revoke a group's permissions if it will reduce their own permission level.

    DELETE api/1.0/projects/{projectKey}/permissions/groups

Parameters:

=over 4

=item * C<<< name >>> - string, default: none

the name of the group

=back

Responses:

=over 4

=item * C<<< 401 >>> - data, type: unknown

The currently authenticated user is not an administrator of the specified
project.

=item * C<<< 204 >>> - data, type: unknown

All project permissions were revoked from the group for the specified project.

=item * C<<< 404 >>> - data, type: unknown

The specified project or group does not exist.

=item * C<<< 409 >>> - data, type: unknown

The action was disallowed as it would reduce the currently authenticated user's
permission level.

=back

=head2 get_groups_without_any_project_permission

Retrieve a page of groups that have no granted permissions for the specified project.

The authenticated user must have B<<< PROJECT_ADMIN >>> permission for the specified project or a higher
global permission to call this resource.

    GET api/1.0/projects/{projectKey}/permissions/groups/none

Parameters:

=over 4

=item * C<<< filter >>> - string, default: none

if specified only group names containing the supplied string will be returned

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of groups that have not been granted any permissions for the specified
project.

=item * C<<< 401 >>> - data, type: unknown

The currently authenticated user is not a project administrator for the
specified project.

=item * C<<< 404 >>> - data, type: unknown

The specified project does not exist.

=back

=head2 set_project_permission_for_users

Promote or demote a user's permission level for the specified project.

The authenticated user must have B<<< PROJECT_ADMIN >>> permission for the specified project or a higher
global permission to call this resource. In addition, a user may not reduce their own permission level unless
they have a global permission that already implies that permission.

    PUT api/1.0/projects/{projectKey}/permissions/users

Parameters:

=over 4

=item * C<<< name >>> - string, default: none

the names of the users

=item * C<<< permission >>> - string, default: none

the permission to grant. See the [permissions documentation](https://confluence.atlassian.com/display/BitbucketServer/Using+project+permissions)
for a detailed explanation of what each permission entails.
Available project permissions are:

=over 4

=item *

PROJECT_READ

=item *

PROJECT_WRITE

=item *

PROJECT_ADMIN

=back

=back

Responses:

=over 4

=item * C<<< 400 >>> - data, type: unknown

The request was malformed or the specified permission does not exist.

=item * C<<< 401 >>> - data, type: unknown

The currently authenticated user is not an administrator for the specified
project.

=item * C<<< 204 >>> - data, type: unknown

The requested permission was granted.

=item * C<<< 403 >>> - data, type: unknown

The action was disallowed as it would reduce the currently authenticated user's
permission level.

=item * C<<< 404 >>> - data, type: unknown

The specified project or user does not exist.

=back

=head2 get_users_with_any_project_permission

Retrieve a page of users that have been granted at least one permission for the specified project.

The authenticated user must have B<<< PROJECT_ADMIN >>> permission for the specified project or a higher
global permission to call this resource.

    GET api/1.0/projects/{projectKey}/permissions/users

Parameters:

=over 4

=item * C<<< filter >>> - string, default: none

if specified only group names containing the supplied string will be returned

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of users and their highest permissions for the specified project.

=item * C<<< 401 >>> - data, type: unknown

The currently authenticated user is not a project administrator for the
specified project.

=item * C<<< 404 >>> - data, type: unknown

The specified project does not exist.

=back

=head2 revoke_project_permissions_for_user

Revoke all permissions for the specified project for a user.

The authenticated user must have B<<< PROJECT_ADMIN >>> permission for the specified project or a higher
global permission to call this resource.

In addition, a user may not revoke their own project permissions if they do not have a higher global permission.

    DELETE api/1.0/projects/{projectKey}/permissions/users

Parameters:

=over 4

=item * C<<< name >>> - string, default: none

the name of the user

=back

Responses:

=over 4

=item * C<<< 401 >>> - data, type: unknown

The currently authenticated user is not an administrator of the specified
project.

=item * C<<< 204 >>> - data, type: unknown

All project permissions were revoked from the user for the specified project.

=item * C<<< 404 >>> - data, type: unknown

The specified project or group does not exist.

=item * C<<< 409 >>> - data, type: unknown

The action was disallowed as it would reduce the currently authenticated user's
permission level.

=back

=head2 get_users_without_project_permission

Retrieve a page of I<<< licensed >>> users that have no granted permissions for the specified project.

The authenticated user must have B<<< PROJECT_ADMIN >>> permission for the specified project or a higher
global permission to call this resource.

    GET api/1.0/projects/{projectKey}/permissions/users/none

Parameters:

=over 4

=item * C<<< filter >>> - string, default: none

if specified only group names containing the supplied string will be returned

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of users that have not been granted any permissions for the specified
project.

=item * C<<< 401 >>> - data, type: unknown

The currently authenticated user is not a project administrator for the
specified project.

=item * C<<< 404 >>> - data, type: unknown

The specified project does not exist.

=back

=head2 modify_all_user_project_permission

Grant or revoke a project permission to all users, i.e. set the default permission.

The authenticated user must have B<<< PROJECT_ADMIN >>> permission for the specified project or a higher
global permission to call this resource.

    POST api/1.0/projects/{projectKey}/permissions/{permission}/all

Parameters:

=over 4

=item * C<<< permission >>> - string, default: none

the permission to grant
Available project permissions are:

=over 4

=item *

PROJECT_READ

=item *

PROJECT_WRITE

=item *

PROJECT_ADMIN

=back

=item * C<<< allow >>> - boolean, default: none

I<<< true >>> to grant the specified permission to all users, or I<<< false >>> to revoke it

=back

Responses:

=over 4

=item * C<<< 400 >>> - data, type: unknown

The request was malformed or the specified permission does not exist.

=item * C<<< 401 >>> - data, type: unknown

The currently authenticated user is not an administrator of the specified
project.

=item * C<<< 204 >>> - data, type: unknown

The requested permission was successfully granted or revoked.

=item * C<<< 404 >>> - data, type: unknown

The specified project does not exist.

=back

=head2 has_all_user_project_permission

Check whether the specified permission is the default permission (granted to all users) for a project.

The authenticated user must have B<<< PROJECT_ADMIN >>> permission for the specified project or a higher
global permission to call this resource.

    GET api/1.0/projects/{projectKey}/permissions/{permission}/all

Parameters:

=over 4

=item * C<<< permission >>> - string, default: none

the permission to grant
Available project permissions are:

=over 4

=item *

PROJECT_READ

=item *

PROJECT_WRITE

=item *

PROJECT_ADMIN

=back

=back

Responses:

=over 4

=item * C<<< 200 >>> - permitted, type: application/json

A simple entity indicating whether the specified permission is the default
permission for this project.

=item * C<<< 400 >>> - data, type: unknown

The request was malformed or the specified permission does not exist.

=item * C<<< 401 >>> - data, type: unknown

The currently authenticated user is not an administrator of the specified
project.

=item * C<<< 404 >>> - data, type: unknown

The specified project does not exist.

=back

=head2 create_repository

Create a new repository. Requires an existing project in which this repository will be created.
The only parameters which will be used are name and scmId.

The authenticated user must have B<<< PROJECT_ADMIN >>> permission for the context project to call this
resource.

    POST api/1.0/projects/{projectKey}/repos

Parameters:

=over 4

=item * C<<< projectKey >>> - string, default: none

the parent project key

=back

Responses:

=over 4

=item * C<<< 201 >>> - repository, type: application/json

The newly created repository.

=item * C<<< 400 >>> - errors, type: application/json

The repository was not created due to a validation error.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to create a
repository.

=item * C<<< 409 >>> - errors, type: application/json

A repository with same name already exists.

=back

=head2 get_repositories

Retrieve repositories from the project corresponding to the supplied B<<< projectKey >>>.

The authenticated user must have B<<< REPO_READ >>> permission for the specified project to call this
resource.

    GET api/1.0/projects/{projectKey}/repos

Parameters:

=over 4

=item * C<<< projectKey >>> - string, default: none

the parent project key

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

The repositories matching the supplied B<<< projectKey >>>.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to see the
specified project.

=item * C<<< 404 >>> - errors, type: application/json

The specified project does not exist.

=back

=head2 get_repository

Retrieve the repository matching the supplied B<<< projectKey >>> and B<<< repositorySlug >>>.

The authenticated user must have B<<< REPO_READ >>> permission for the specified repository to call this
resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}

Parameters:

=over 4

=item * C<<< projectKey >>> - string, default: none

the parent project key

=item * C<<< projectKey >>> - string, default: none

the parent project key

=item * C<<< repositorySlug >>> - string, default: none

the repository slug

=back

Responses:

=over 4

=item * C<<< 200 >>> - repository, type: application/json

The repository which matches the supplied B<<< projectKey >>> and
B<<< repositorySlug >>>.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to see the
specified repository.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository does not exist.

=back

=head2 update_repository

Update the repository matching the B<<< repositorySlug >>> supplied in the resource path.

The repository's slug is derived from its name. If the name changes the slug may also change.

This API can be used to move the repository to a different project by setting the new project in the request,
example: C<<< {"project":{"key":"NEW_KEY" >>>}} .

The authenticated user must have B<<< REPO_ADMIN >>> permission for the specified repository to call this
resource.

    PUT api/1.0/projects/{projectKey}/repos/{repositorySlug}

Parameters:

=over 4

=item * C<<< projectKey >>> - string, default: none

the parent project key

=item * C<<< projectKey >>> - string, default: none

the parent project key

=item * C<<< repositorySlug >>> - string, default: none

the repository slug

=back

Responses:

=over 4

=item * C<<< 201 >>> - repository, type: application/json

The updated repository.

=item * C<<< 400 >>> - errors, type: application/json

The repository was not updated due to a validation error.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to update a
repository

=item * C<<< 404 >>> - errors, type: application/json

The specified repository does not exist.

=item * C<<< 409 >>> - errors, type: application/json

A repository with same name as the target already exists

=back

=head2 delete_repository

Schedule the repository matching the supplied B<<< projectKey >>> and B<<< repositorySlug >>> to
be deleted. If the request repository is not present

The authenticated user must have B<<< REPO_ADMIN >>> permission for the specified repository to call this
resource.

    DELETE api/1.0/projects/{projectKey}/repos/{repositorySlug}

Parameters:

=over 4

=item * C<<< projectKey >>> - string, default: none

the parent project key

=item * C<<< projectKey >>> - string, default: none

the parent project key

=item * C<<< repositorySlug >>> - string, default: none

the repository slug

=back

Responses:

=over 4

=item * C<<< 202 >>> - message, type: application/json

The repository has been scheduled for deletion.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to delete the
repository.

=item * C<<< 204 >>> - data, type: unknown

No repository matching the supplied B<<< projectKey >>> and
B<<< repositorySlug >>> was found.

=back

=head2 fork_repository

Create a new repository forked from an existing repository.

The JSON body for this C<<< POST >>> is not required to contain I<<< any >>> properties. Even the name may be
omitted. The following properties will be used, if provided:

=over 4

=item *

C<<< "name":"Fork name" >>> - Specifies the forked repository's name

=over 4

=item *

Defaults to the name of the origin repository if not specified

=back

=item *

C<<< "project":{"key":"TARGET_KEY" >>>} - Specifies the forked repository's target project by key

=over 4

=item *

Defaults to the current user's personal project if not specified

=back

=back

The authenticated user must have B<<< REPO_READ >>> permission for the specified repository and
B<<< PROJECT_ADMIN >>> on the target project to call this resource. Note that users I<<< always >>>
have B<<< PROJECT_ADMIN >>> permission on their personal projects.

    POST api/1.0/projects/{projectKey}/repos/{repositorySlug}

Parameters:

=over 4

=item * C<<< projectKey >>> - string, default: none

the parent project key

=item * C<<< projectKey >>> - string, default: none

the parent project key

=item * C<<< repositorySlug >>> - string, default: none

the repository slug

=back

Responses:

=over 4

=item * C<<< 201 >>> - repository, type: application/json

The newly created fork.

=item * C<<< 400 >>> - errors, type: application/json

A validation error prevented the fork from being created. Possible validation
errors include: The name or slug for the fork collides with another repository
in the target project; an SCM type was specified in the JSON body; a project
was specified in the JSON body without a "key" property.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to create a
fork.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository does not exist, or, if a target project was specified,
the target project does not exist.

=back

=head2 get_archive

Streams an archive of the repository's contents at the requested commit. If no C<<< at= >>> commit is
requested, an archive of the default branch is streamed.

The C<<< filename= >>> query parameter may be used to specify the exact filename to include in the
C<<< "Content-Disposition" >>> header. If an explicit filename is not provided, one will be automatically
generated based on what is being archived. Its format depends on the C<<< at= >>> value:

=over 4

=item *

No C<<< at= >>> commit:
C<<< &lt;slug&gt;-&lt;default-branch-name&gt;@&lt;commit&gt;.&lt;format&gt; >>>;
e.g. example-master@43c2f8a0fe8.zip

=item *

C<<< at=sha >>>: C<<< &lt;slug&gt;-&lt;at&gt;.&lt;format&gt; >>>; e.g.
example-09bcbb00100cfbb5310fb6834a1d5ce6cac253e9.tar.gz

=item *

C<<< at=branchOrTag >>>: C<<< &lt;slug&gt;-&lt;branchOrTag&gt;@&lt;commit&gt;.&lt;format&gt; >>>;
e.g. example-feature@bbb225f16e1.tar

=over 4

=item *

If the branch or tag is qualified (e.g. C<<< refs/heads/master >>>, the short name
(C<<< master >>>) will be included in the filename

=item *

If the branch or tag's I<<< short name >>> includes slashes (e.g. C<<< release/4.6 >>>),
they will be converted to hyphens in the filename (C<<< release-4.5 >>>)

=back

=back

Archives may be requested in the following formats by adding the C<<< format= >>> query parameter:

=over 4

=item *

C<<< zip >>>: A zip file using standard compression (Default)

=item *

C<<< tar >>>: An uncompressed tarball

=item *

C<<< tar.gz >>> or C<<< tgz >>>: A GZip-compressed tarball

=back

The contents of the archive may be filtered by using the C<<< path= >>> query parameter to specify paths to
include. C<<< path= >>> may be specified multiple times to include multiple paths.

The C<<< prefix= >>> query parameter may be used to define a directory (or multiple directories) where
the archive's contents should be placed. If the prefix does not end with C<<< / >>>, one will be added
automatically. The prefix is I<<< always >>> treated as a directory; it is not possible to use it to prepend
characters to the entries in the archive.

Archives of public repositories may be streamed by any authenticated or anonymous user. Streaming archives for
non-public repositories requires an I<<< authenticated user >>> with at least B<<< REPO_READ >>> permission.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/archive

Parameters:

=over 4

=item * C<<< at >>> - string, default: none

the commit to stream an archive of; if not supplied, an archive of the default branch is streamed

=item * C<<< filename >>> - string, default: none

a filename to include the "Content-Disposition" header

=item * C<<< format >>> - string, default: none

the format to stream the archive in; must be one of: zip, tar, tar.gz or tgz

=item * C<<< path >>> - string, default: none

paths to include in the streamed archive; may be repeated to include multiple paths

=item * C<<< prefix >>> - string, default: none

a prefix to apply to all entries in the streamed archive; if the supplied prefix does not end
with a trailing C<<< / >>>, one will be added automatically

=back

Responses:

=over 4

=item * C<<< 200 >>> - archive, type: application/octet-stream; application/x-tar

An archive or the requested commit, in zip, tar or gzipped-tar format.

=item * C<<< 400 >>> - errors, type: application/json

The requested C<<< format >>> is not supported.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions
to view the repository.

=item * C<<< 404 >>> - errors, type: application/json

The repository does not exist or does not contain the C<<< at >>> commit.

=back

=head2 create_branch

Creates a branch using the information provided in the request

The authenticated user must have B<<< REPO_WRITE >>> permission for the context repository to call
this resource.

    POST api/1.0/projects/{projectKey}/repos/{repositorySlug}/branches

Responses:

=over 4

=item * C<<< 200 >>> - branch, type: application/json

The created branch

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to write to the
repository.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository does not exist.

=back

=head2 get_branches

Retrieve the branches matching the supplied B<<< filterText >>> param.

The authenticated user must have B<<< REPO_READ >>> permission for the specified repository to call this
resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/branches

Parameters:

=over 4

=item * C<<< base >>> - string, default: none

base branch or tag to compare each branch to (for the metadata providers that uses that information)

=item * C<<< details >>> - boolean, default: none

whether to retrieve plugin-provided metadata about each branch

=item * C<<< filterText >>> - string, default: none

the text to match on

=item * C<<< orderBy >>> - string, default: none

ordering of refs either ALPHABETICAL (by name) or MODIFICATION (last updated)

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

The branches matching the supplied B<<< filterText >>>.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to read the
repository.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository does not exist.

=back

=head2 get_default_branch

Get the default branch of the repository.

The authenticated user must have B<<< REPO_READ >>> permission for the specified repository to call this
resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/branches/default

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

The configured default branch for the repository.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to read the
repository.

=item * C<<< 204 >>> - data, type: unknown

The repository is empty, and has no default branch.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository does not exist, or its configured default branch
does not exist.

=back

=head2 set_default_branch

Update the default branch of a repository.

The authenticated user must have B<<< REPO_ADMIN >>> permission for the specified repository to call this
resource.

    PUT api/1.0/projects/{projectKey}/repos/{repositorySlug}/branches/default

Responses:

=over 4

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to update the
repository

=item * C<<< 204 >>> - data, type: unknown

The operation was successful

=item * C<<< 404 >>> - errors, type: application/json

The specified repository does not exist.

=back

=head2 get_file

Retrieve a page of content for a file path at a specified revision.

The authenticated user must have B<<< REPO_READ >>> permission for the specified repository to call this
resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/browse/{path:.*}

Parameters:

=over 4

=item * C<<< path >>> - string, default: none

the path of the file that is to be modified or created

=item * C<<< at >>> - string, default: none

the commit ID or ref to retrieve the content for.

=item * C<<< type >>> - boolean, default: false

if true only the type will be returned for the file path instead of the contents.

=item * C<<< blame >>> - string, default: none

if present the blame will be returned for the file as well.

=item * C<<< noContent >>> - string, default: none

if present and used with blame only the blame is retrieved instead of the contents.

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of contents from a file.

=item * C<<< 400 >>> - errors, type: application/json

The path or until parameters were not supplied.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions
to view the repository.

=item * C<<< 404 >>> - errors, type: application/json

The repository does not exist.

=back

=head2 edit_file

Update the content of C<<< path >>>, on the given C<<< repository >>> and C<<< branch >>>.

This resource accepts PUT multipart form data, containing the file in a form-field named C<<< content >>>.

An example L<<< curl|http://curl.haxx.se/ >>> request to update 'README.md' would be:

    curl -X PUT -u username:password -F content=@README.md  -F 'message=Updated using file-edit REST API'
    -F branch=master -F  sourceCommitId=5636641a50b
    http://example.com/rest/api/latest/projects/PROJECT_1/repos/repo_1/browse/README.md

=over 4

=item *

branch:  the branch on which the C<<< path >>> should be modified or created

=item *

content: the full content of the file at C<<< path >>>

=item *

message: the message associated with this change, to be used as the commit message.
Or null if the default message should be used.

=item *

sourceCommitId: the commit ID of the file before it was edited, used to identify if
content has changed. Or null if this is a new file

=back

The file can be updated or created on a new branch. In this case, the C<<< sourceBranch >>> parameter should
be provided to identify the starting point for the new branch and the C<<< branch >>> parameter identifies
the branch to create the new commit on.

    PUT api/1.0/projects/{projectKey}/repos/{repositorySlug}/browse/{path:.*}

Parameters:

=over 4

=item * C<<< path >>> - string, default: none

the path of the file that is to be modified or created

=back

Responses:

=over 4

=item * C<<< 200 >>> - data, type: application/json

The newly created commit

=item * C<<< 400 >>> - errors, type: application/json

The branch or content parameters were not supplied.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user does not have write permission for the
given repository

=item * C<<< 404 >>> - errors, type: application/json

The repository does not exist.

=item * C<<< 409 >>> - errors, type: application/json

The file already exists when trying to create a file, or the given content does
not modify the file, or the file has changed since the given sourceCommitId

=back

=head2 get_repository_changes

Retrieve a page of changes made in a specified commit.

B<<< Note: >>> The implementation will apply a hard cap (C<<< page.max.changes >>>) and it is not
possible to request subsequent content when that cap is exceeded.

The authenticated user must have B<<< REPO_READ >>> permission for the specified repository to call this
resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/changes

Parameters:

=over 4

=item * C<<< since >>> - string, default: none

the commit to which C<<< until >>> should be compared to produce a page of changes.
If not specified the commit's first parent is assumed (if one exists)

=item * C<<< until >>> - string, default: none

the commit to retrieve changes for

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of changes

=item * C<<< 400 >>> - errors, type: application/json

The until parameter was not supplied

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions
to view the repository.

=item * C<<< 404 >>> - errors, type: application/json

The repository or the since or until parameters
supplied does not exist.

=back

=head2 get_repository_commits

Retrieve a page of commits from a given starting commit or "between" two commits. If no explicit commit is
specified, the tip of the repository's default branch is assumed. commits may be identified by branch or tag
name or by ID. A path may be supplied to restrict the returned commits to only those which affect that path.

The authenticated user must have B<<< REPO_READ >>> permission for the specified repository to call this
resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits

Parameters:

=over 4

=item * C<<< followRenames >>> - boolean, default: false

if C<<< true >>>, the commit history of the specified file will be followed past renames.
Only valid for a path to a single file.

=item * C<<< ignoreMissing >>> - boolean, default: false

C<<< true >>> to ignore missing commits, C<<< false >>> otherwise

=item * C<<< merges >>> - string, default: none

if present, controls how merge commits should be filtered. Can be either C<<< exclude >>>,
to exclude merge commits, C<<< include >>>, to include both merge commits and non-merge
commits or C<<< only >>>, to only return merge commits.

=item * C<<< path >>> - string, default: none

an optional path to filter commits by

=item * C<<< since >>> - string, default: none

the commit ID or ref (exclusively) to retrieve commits after

=item * C<<< until >>> - string, default: none

the commit ID (SHA1) or ref (inclusively) to retrieve commits before

=item * C<<< withCounts >>> - boolean, default: false

optionally include the total number of commits and total number of unique authors

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of commits.

=item * C<<< 400 >>> - errors, type: application/json

One of the supplied commit IDs or refs was invalid.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions
to view the repository.

=item * C<<< 404 >>> - errors, type: application/json

The repository does not exist.

=back

=head2 get_commit

Retrieve a single commit I<<< identified by its ID >>>>. In general, that ID is a SHA1. I<<< From 2.11, ref names
like "refs/heads/master" are no longer accepted by this resource. >>>

The authenticated user must have B<<< REPO_READ >>> permission for the specified repository to call this
resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}

Parameters:

=over 4

=item * C<<< commitId >>> - string, default: none

the commit ID to retrieve

=item * C<<< path >>> - string, default: none

an optional path to filter the commit by. If supplied the details returned I<<< may not >>>
be for the specified commit. Instead, starting from the specified commit, they will be the
details for the first commit affecting the specified path.

=back

Responses:

=over 4

=item * C<<< 200 >>> - commit, type: application/json

A commit.

=item * C<<< 400 >>> - errors, type: application/json

The supplied commit ID was invalid.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions
to view the repository.

=item * C<<< 404 >>> - errors, type: application/json

The repository does not exist.

=back

=head2 get_commit_changes

Retrieve a page of changes made in a specified commit.

B<<< Note: >>> The implementation will apply a hard cap (C<<< page.max.changes >>>) and it is not
possible to request subsequent content when that cap is exceeded.

The authenticated user must have B<<< REPO_READ >>> permission for the specified repository to call this
resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/changes

Parameters:

=over 4

=item * C<<< commitId >>> - string, default: none

the commit to retrieve changes for

=item * C<<< since >>> - string, default: none

the commit to which C<<< until >>> should be compared to produce a page of changes.
If not specified the commit's first parent is assumed (if one exists)

=item * C<<< withComments >>> - boolean, default: true

C<<< true >>> to apply comment counts in the changes (the default); otherwise, C<<< false >>>
to stream changes without comment counts

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of changes

=item * C<<< 400 >>> - errors, type: application/json

The until parameter was not supplied

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to view
the repository.

=item * C<<< 404 >>> - errors, type: application/json

The repository or the since or until parameters supplied does not exist.

=back

=head2 get_commit_comments

Retrieves the commit discussion comments that match the specified search criteria.

It is possible to retrieve commit discussion comments that are anchored to a range of commits by providing the
C<<< sinceId >>> that the comments anchored from.

The authenticated user must have B<<< REPO_READ >>> permission for the repository that the commit
is in to call this resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/comments

Parameters:

=over 4

=item * C<<< commitId >>> - string, default: none

the I<<< full ID >>> of the commit within the repository

=item * C<<< path >>> - string, default: none

the path to the file on which comments were made

=item * C<<< since >>> - string, default: none

For a merge commit, a parent can be provided to specify which diff the comments are on. For
a commit range, a C<<< sinceId >>> can be provided to specify where the comments are anchored
from.

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of comments that match the search criteria

=item * C<<< 400 >>> - errors, type: application/json

The request was malformed.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to view the comment

=item * C<<< 404 >>> - errors, type: application/json

Unable to find the supplied project, repository, or commit. The
missing entity will be specified in the error details.

=back

=head2 create_commit_comment

Add a new comment.

Comments can be added in a few places by setting different attributes:

General commit comment:

    {
       "text" : "An insightful general comment on a commit."
    }

Reply to a comment:

    {
       "parent" : {
          "id" : 1
       },
       "text" : "A measured reply."
    }

General file comment:

    {
       "anchor" : {
          "diffType" : "COMMIT",
          "fromHash" : "6df3858eeb9a53a911cd17e66a9174d44ffb02cd",
          "path" : "path/to/file",
          "srcPath" : "path/to/file",
          "toHash" : "04c7c5c931b9418ca7b66f51fe934d0bd9b2ba4b"
       },
       "text" : "An insightful general comment on a file."
    }

File line comment:

    {
       "anchor" : {
          "diffType" : "COMMIT",
          "fileType" : "FROM",
          "fromHash" : "6df3858eeb9a53a911cd17e66a9174d44ffb02cd",
          "line" : 1,
          "lineType" : "CONTEXT",
          "path" : "path/to/file",
          "srcPath" : "path/to/file",
          "toHash" : "04c7c5c931b9418ca7b66f51fe934d0bd9b2ba4b"
       },
       "text" : "A pithy comment on a particular line within a file."
    }

B<<< Note: general file comments are an experimental feature and may change in the near future! >>>

For file and line comments, 'path' refers to the path of the file to which the comment should be applied and
'srcPath' refers to the path the that file used to have (only required for copies and moves). Also,
fromHash and toHash refer to the sinceId / untilId (respectively) used to produce the diff on which the comment
was added. Finally diffType refers to the type of diff the comment was added on.

For line comments, 'line' refers to the line in the diff that the comment should apply to. 'lineType' refers to
the type of diff hunk, which can be:

=over 4

=item *

'ADDED' - for an added line;

=item *

'REMOVED' - for a removed line; or

=item *

'CONTEXT' - for a line that was unmodified but is in the vicinity of the diff.

=back

'fileType' refers to the file of the diff to which the anchor should be attached - which is of relevance when
displaying the diff in a side-by-side way. Currently the supported values are:

=over 4

=item *

'FROM' - the source file of the diff

=item *

'TO' - the destination file of the diff

=back

If the current user is not a participant the user is added as one and updated to watch the commit.

The authenticated user must have B<<< REPO_READ >>> permission for the repository that the commit
is in to call this resource.

    POST api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/comments

Parameters:

=over 4

=item * C<<< commitId >>> - string, default: none

the I<<< full ID >>> of the commit within the repository

=item * C<<< since >>> - string, default: none

For a merge commit, a parent can be provided to specify which diff the comments should be on. For
a commit range, a C<<< sinceId >>> can be provided to specify where the comments should be
anchored from.

=back

Responses:

=over 4

=item * C<<< 201 >>> - comment, type: application/json

The newly created comment.

=item * C<<< 400 >>> - errors, type: application/json

The comment was not created due to a validation error.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to view the
commit, create a comment or watch the commit.

=item * C<<< 404 >>> - errors, type: application/json

Unable to find the supplied project, repository, commit or parent comment.
The missing entity will be specified in the error details.

=back

=head2 get_commit_comment

Retrieves a commit discussion comment.

The authenticated user must have B<<< REPO_READ >>> permission for the repository that the commit
is in to call this resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/comments/{commentId}

Parameters:

=over 4

=item * C<<< commitId >>> - string, default: none

the I<<< full ID >>> of the commit within the repository

=item * C<<< commentId >>> - long, default: none

the ID of the comment to retrieve

=item * C<<< commitId >>> - string, default: none

the I<<< full ID >>> of the commit within the repository

=back

Responses:

=over 4

=item * C<<< 200 >>> - comment, type: application/json

The requested comment.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to view the comment

=item * C<<< 404 >>> - errors, type: application/json

Unable to find the supplied project, repository, commit or comment. The
missing entity will be specified in the error details.

=back

=head2 delete_commit_comment

Delete a commit comment. Anyone can delete their own comment. Only users with B<<< REPO_ADMIN >>>
and above may delete comments created by other users. Comments which have replies I<<< may not be deleted >>>,
regardless of the user's granted permissions.

The authenticated user must have B<<< REPO_READ >>> permission for the repository that the commit
is in to call this resource.

    DELETE api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/comments/{commentId}

Parameters:

=over 4

=item * C<<< commitId >>> - string, default: none

the I<<< full ID >>> of the commit within the repository

=item * C<<< commentId >>> - long, default: none

the ID of the comment to retrieve

=item * C<<< commitId >>> - string, default: none

the I<<< full ID >>> of the commit within the repository

=item * C<<< version >>> - int, default: -1

The expected version of the comment. This must match the server's version of the comment or
the delete will fail. To determine the current version of the comment, the comment should be
fetched from the server prior to the delete. Look for the 'version' attribute in the returned
JSON structure.

=back

Responses:

=over 4

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to delete the comment.

=item * C<<< 204 >>> - data, type: unknown

The operation was successful

=item * C<<< 404 >>> - errors, type: application/json

Unable to find the supplied project, repository or commit. The missing
entity will be specified in the error details.

=item * C<<< 409 >>> - errors, type: application/json

The comment has replies or the version supplied does not match the comment's
current version.

=back

=head2 update_commit_comment

Update the text of a comment. Only the user who created a comment may update it.

B<<< Note: >>> the supplied supplied JSON object must contain a C<<< version >>> that must match
the server's version of the comment or the update will fail. To determine the current version of the comment,
the comment should be fetched from the server prior to the update. Look for the 'version' attribute in the
returned JSON structure.

The authenticated user must have B<<< REPO_READ >>> permission for the repository that the commit
is in to call this resource.

    PUT api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/comments/{commentId}

Parameters:

=over 4

=item * C<<< commitId >>> - string, default: none

the I<<< full ID >>> of the commit within the repository

=item * C<<< commentId >>> - long, default: none

the ID of the comment to retrieve

=item * C<<< commitId >>> - string, default: none

the I<<< full ID >>> of the commit within the repository

=back

Responses:

=over 4

=item * C<<< 201 >>> - comment, type: application/json

The newly updated comment.

=item * C<<< 400 >>> - errors, type: application/json

The comment was not updated due to a validation error.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to view the
commit, update the comment or watch the commit.

=item * C<<< 404 >>> - errors, type: application/json

Unable to find the supplied project, repository, commit or comment. The
missing entity will be specified in the error details.

=item * C<<< 409 >>> - errors, type: application/json

The comment version supplied does not match the current version.

=back

=head2 stream_commit_diff

Retrieve the diff between two provided revisions.

B<<< Note: >>> This resource is currently I<<< not paged >>>. The server will internally apply a hard cap
to the streamed lines, and it is not possible to request subsequent pages if that cap is exceeded. In the event
that the cap is reached, the diff will be cut short and one or more C<<< truncated >>> flags will be set to
C<<< true >>> on the C<<< "segments" >>>, C<<< "hunks" >>> and C<<< "diffs" >>> properties, as well as the top-level
object, in the returned JSON response.

The authenticated user must have B<<< REPO_READ >>> permission for the specified repository to call this
resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/diff/{path:.*}

Parameters:

=over 4

=item * C<<< commitId >>> - string, default: none

=item * C<<< path >>> - string, default: none

the path to the file which should be diffed (optional)

=item * C<<< commitId >>> - string, default: none

=item * C<<< autoSrcPath >>> - boolean, default: false

C<<< true >>> to automatically try to find the source path when it's not provided,
C<<< false >>> otherwise. Requires the C<<< path >>> to be provided.

=item * C<<< contextLines >>> - int, default: -1

the number of context lines to include around added/removed lines in the diff

=item * C<<< since >>> - string, default: none

the base revision to diff from. If omitted the parent revision of the until revision is used

=item * C<<< srcPath >>> - string, default: none

the source path for the file, if it was copied, moved or renamed

=item * C<<< whitespace >>> - string, default: none

optional whitespace flag which can be set to C<<< ignore-all >>>

=item * C<<< withComments >>> - boolean, default: true

C<<< true >>> to embed comments in the diff (the default); otherwise C<<< false >>>
to stream the diff without comments

=back

Responses:

=over 4

=item * C<<< 200 >>> - diff, type: application/json

A diff between two revisions.

=item * C<<< 400 >>> - errors, type: application/json

The until parameter was not supplied.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions
to view the repository.

=item * C<<< 404 >>> - errors, type: application/json

The repository does not exist.

=back

=head2 watch_commit

Add the authenticated user as a watcher for the specified commit.

The authenticated user must have B<<< REPO_READ >>> permission for the repository containing the commit
to call this resource.

    POST api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/watch

Parameters:

=over 4

=item * C<<< commitId >>> - string, default: none

the I<<< full ID >>> of the commit within the repository

=back

Responses:

=over 4

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to view the pull
request.

=item * C<<< 204 >>> - data, type: unknown

The user is now watching the commit.

=item * C<<< 404 >>> - errors, type: application/json

The specified project, repository or commit does not exist.

=back

=head2 unwatch_commit

Remove the authenticated user as a watcher for the specified commit.

The authenticated user must have B<<< REPO_READ >>> permission for the repository containing the commit
to call this resource.

    DELETE api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/watch

Parameters:

=over 4

=item * C<<< commitId >>> - string, default: none

the I<<< full ID >>> of the commit within the repository

=back

Responses:

=over 4

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to view the pull
request.

=item * C<<< 204 >>> - data, type: unknown

The user is no longer watching the commit.

=item * C<<< 404 >>> - errors, type: application/json

The specified project, repository or commit does not exist.

=back

=head2 stream_changes

Gets the file changes available in the C<<< from >>> commit but not in the C<<< to >>> commit.

If either the C<<< from >>> or C<<< to >>> commit are not specified, they will be replaced by the
default branch of their containing repository.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/compare/changes

Parameters:

=over 4

=item * C<<< from >>> - string, default: none

the source commit (can be a partial/full commit ID or qualified/unqualified ref name)

=item * C<<< to >>> - string, default: none

the target commit (can be a partial/full commit ID or qualified/unqualified ref name)

=item * C<<< fromRepo >>> - string, default: none

an optional parameter specifying the source repository containing the source commit
if that commit is not present in the current repository; the repository can be specified
by either its ID I<<< fromRepo=42 >>> or by its project key plus its repo slug separated by
a slash: I<<< fromRepo=projectKey/repoSlug >>>

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of changes.

=item * C<<< 404 >>> - errors, type: application/json

The source or target commit does not exist.

=back

=head2 stream_commits

Gets the commits accessible from the C<<< from >>> commit but not in the C<<< to >>> commit.

If either the C<<< from >>> or C<<< to >>> commit are not specified, they will be replaced by the
default branch of their containing repository.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/compare/commits

Parameters:

=over 4

=item * C<<< from >>> - string, default: none

the source commit (can be a partial/full commit ID or qualified/unqualified ref name)

=item * C<<< to >>> - string, default: none

the target commit (can be a partial/full commit ID or qualified/unqualified ref name)

=item * C<<< fromRepo >>> - string, default: none

an optional parameter specifying the source repository containing the source commit
if that commit is not present in the current repository; the repository can be specified
by either its ID I<<< fromRepo=42 >>> or by its project key plus its repo slug separated by
a slash: I<<< fromRepo=projectKey/repoSlug >>>

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of commits.

=item * C<<< 404 >>> - errors, type: application/json

The source or target commit does not exist.

=back

=head2 stream_diff

Gets a diff of the changes available in the C<<< from >>> commit but not in the C<<< to >>> commit.

If either the C<<< from >>> or C<<< to >>> commit are not specified, they will be replaced by the
default branch of their containing repository.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/compare/diff{path:.*}

Parameters:

=over 4

=item * C<<< path >>> - string, default: none

the path to the file to diff (optional)

=item * C<<< from >>> - string, default: none

the source commit (can be a partial/full commit ID or qualified/unqualified ref name)

=item * C<<< to >>> - string, default: none

the target commit (can be a partial/full commit ID or qualified/unqualified ref name)

=item * C<<< fromRepo >>> - string, default: none

an optional parameter specifying the source repository containing the source commit
if that commit is not present in the current repository; the repository can be specified
by either its ID I<<< fromRepo=42 >>> or by its project key plus its repo slug separated by
a slash: I<<< fromRepo=projectKey/repoSlug >>>

=item * C<<< srcPath >>> - string, default: none

=item * C<<< contextLines >>> - int, default: -1

an optional number of context lines to include around each added or removed lines in the diff

=item * C<<< whitespace >>> - string, default: none

an optional whitespace flag which can be set to C<<< ignore-all >>>

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

The diff of the changes.

=item * C<<< 404 >>> - errors, type: application/json

The source or target commit does not exist.

=back

=head2 stream_repository_diff

Retrieve the diff for a specified file path between two provided revisions.

B<<< Note: >>> This resource is currently I<<< not paged >>>. The server will internally apply a hard cap
to the streamed lines, and it is not possible to request subsequent pages if that cap is exceeded. In the event
that the cap is reached, the diff will be cut short and one or more C<<< truncated >>> flags will be set to
C<<< true >>> on the segments, hunks and diffs substructures in the returned JSON response.

The authenticated user must have B<<< REPO_READ >>> permission for the specified repository to call this
resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/diff/{path:.*}

Parameters:

=over 4

=item * C<<< path >>> - string, default: none

the path to the file which should be diffed (required)

=item * C<<< contextLines >>> - int, default: -1

the number of context lines to include around added/removed lines in the diff

=item * C<<< since >>> - string, default: none

the base revision to diff from. If omitted the parent revision of the until revision is used

=item * C<<< srcPath >>> - string, default: none

the source path for the file, if it was copied, moved or renamed

=item * C<<< until >>> - string, default: none

the target revision to diff to (required)

=item * C<<< whitespace >>> - string, default: none

optional whitespace flag which can be set to C<<< ignore-all >>>

=back

Responses:

=over 4

=item * C<<< 200 >>> - diff, type: application/json

A diff of a file path.

=item * C<<< 400 >>> - errors, type: application/json

The path or until parameters were not supplied.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions
to view the repository.

=item * C<<< 404 >>> - errors, type: application/json

The repository does not exist.

=back

=head2 get_repository_files

Retrieve a page of files from particular directory of a repository. The search is done recursively, so all files
from any sub-directory of the specified directory will be returned.

The authenticated user must have B<<< REPO_READ >>> permission for the specified repository to call this
resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/files/{path:.*}

Parameters:

=over 4

=item * C<<< path >>> - string, default: none

the directory to list files for.

=item * C<<< at >>> - string, default: none

the commit ID or ref (e.g. a branch or tag) to list the files at.
If not specified the default branch will be used instead.

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of files.

=item * C<<< 400 >>> - errors, type: application/json

The path requested is not a directory at the supplied commit.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions
to view the repository.

=item * C<<< 404 >>> - errors, type: application/json

The path requested does not exist at the supplied commit.

=back

=head2 get_forked_repositories

Retrieve repositories which have been forked from this one. Unlike related repositories, this only looks at a given repository's direct forks. If those forks have
themselves been the origin of more forks, such "grandchildren" repositories will not be retrieved.

Only repositories to which the authenticated user has B<<< REPO_READ >>> permission will be included, even
if other repositories have been forked from this one.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/forks

Parameters:

=over 4

=item * C<<< projectKey >>> - string, default: none

the parent project key

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of repositories related to the request repository.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to see the
request repository.

=item * C<<< 404 >>> - errors, type: application/json

The request repository does not exist.

=back

=head2 stream_last_modified

Streams files in the requested C<<< path >>> with the last commit to modify each file. Commit modifications
are traversed starting from the C<<< at >>> commit or, if not specified, from the tip of the default branch.

Unless the repository is public, the authenticated user must have B<<< REPO_READ >>> access to call this resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/last-modified/{path:.*}

Parameters:

=over 4

=item * C<<< path >>> - string, default: none

the path within the repository whose files should be streamed

=item * C<<< at >>> - string, default: none

the commit to use as the starting point when listing files and calculating modifications

=back

Responses:

=over 4

=item * C<<< 200 >>> - modifications, type: application/json

A map of files to the last commit that modified them, and the latest commit
to update the requested path.

=item * C<<< 400 >>> - errors, type: application/json

No C<<< at >>> commit was specified. When streaming modifications, an
explicit starting commit must be supplied.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions
to view the repository.

=item * C<<< 404 >>> - errors, type: application/json

The repository does not exist or does not contain the C<<< at >>> commit,
or the C<<< at >>> commit does not contain the requested path.

=back

=head2 get_repository_participants

Retrieve a page of participant users for all the pull requests to or from the specified repository.

Optionally clients can specify following filters.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/participants

Parameters:

=over 4

=item * C<<< direction >>> - string, default: incoming

(optional, defaults to B<<< INCOMING >>>) the direction relative to the specified
repository. Either B<<< INCOMING >>> or B<<< OUTGOING >>>.

=item * C<<< filter >>> - string, default: none

(optional) return only users, whose username, name or email address I<<< contain >>>
the C<<< filter >>> value

=item * C<<< role >>> - string, default: none

(optional) The role associated with the pull request participant.
This must be one of C<<< AUTHOR >>>, C<<< REVIEWER >>>, orC<<< PARTICIPANT >>>

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of users that match the search criteria.

=item * C<<< 400 >>> - errors, type: application/json

The request was malformed.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to view the specified repository.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository does not exist.

=back

=head2 get_groups_with_any_repository_permission

Retrieve a page of groups that have been granted at least one permission for the specified repository.

The authenticated user must have B<<< REPO_ADMIN >>> permission for the specified repository or a higher
project or global permission to call this resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/permissions/groups

Parameters:

=over 4

=item * C<<< filter >>> - string, default: none

if specified only group names containing the supplied string will be returned

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of groups and their highest permissions for the specified repository.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user is not a repository administrator for the
specified repository.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository does not exist.

=back

=head2 set_repository_permission_for_group

Promote or demote a group's permission level for the specified repository. Available repository permissions are:

=over 4

=item *

REPO_READ

=item *

REPO_WRITE

=item *

REPO_ADMIN

=back

See the L<<< Bitbucket
Server documentation|https://confluence.atlassian.com/display/BitbucketServer/Using+repository+permissions >>> for a detailed explanation of what each permission entails.

The authenticated user must have B<<< REPO_ADMIN >>> permission for the specified repository or a higher
project or global permission to call this resource. In addition, a user may not demote a group's permission level if their
own permission level would be reduced as a result.

    PUT api/1.0/projects/{projectKey}/repos/{repositorySlug}/permissions/groups

Parameters:

=over 4

=item * C<<< permission >>> - string, default: none

the permission to grant

=item * C<<< name >>> - string, default: none

the names of the groups

=back

Responses:

=over 4

=item * C<<< 400 >>> - errors, type: application/json

The request was malformed or the specified permission does not exist.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user is not an administrator for the specified
repository.

=item * C<<< 204 >>> - data, type: unknown

The requested permission was granted.

=item * C<<< 403 >>> - errors, type: application/json

The action was disallowed as it would reduce the currently authenticated user's
permission level.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository or group does not exist.

=back

=head2 revoke_repository_permissions_for_group

Revoke all permissions for the specified repository for a group.

The authenticated user must have B<<< REPO_ADMIN >>> permission for the specified repository or a higher
project or global permission to call this resource.

In addition, a user may not revoke a group's permissions if it will reduce their own permission level.

    DELETE api/1.0/projects/{projectKey}/repos/{repositorySlug}/permissions/groups

Parameters:

=over 4

=item * C<<< name >>> - string, default: none

the name of the group

=back

Responses:

=over 4

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user is not an administrator of the specified
repository.

=item * C<<< 204 >>> - data, type: unknown

All repository permissions were revoked from the group for the specified repository.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository or group does not exist.

=item * C<<< 409 >>> - errors, type: application/json

The action was disallowed as it would reduce the currently authenticated user's
permission level.

=back

=head2 get_groups_without_any_repository_permission

Retrieve a page of groups that have no granted permissions for the specified repository.

The authenticated user must have B<<< REPO_ADMIN >>> permission for the specified repository or a higher
project or global permission to call this resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/permissions/groups/none

Parameters:

=over 4

=item * C<<< filter >>> - string, default: none

if specified only group names containing the supplied string will be returned

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of groups that have not been granted any permissions for the specified
repository.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user is not a repository administrator for the
specified repository.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository does not exist.

=back

=head2 get_users_with_any_repository_permission

Retrieve a page of users that have been granted at least one permission for the specified repository.

The authenticated user must have B<<< REPO_ADMIN >>> permission for the specified repository or a higher
project or global permission to call this resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/permissions/users

Parameters:

=over 4

=item * C<<< filter >>> - string, default: none

if specified only group names containing the supplied string will be returned

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of users and their highest permissions for the specified repository.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user is not a repository administrator for the
specified repository.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository does not exist.

=back

=head2 set_repository_permission_for_user

Promote or demote a user's permission level for the specified repository. Available repository permissions are:

=over 4

=item *

REPO_READ

=item *

REPO_WRITE

=item *

REPO_ADMIN

=back

See the L<<< Bitbucket
Server documentation|https://confluence.atlassian.com/display/BitbucketServer/Using+repository+permissions >>> for a detailed explanation of what each permission entails.

The authenticated user must have B<<< REPO_ADMIN >>> permission for the specified repository or a higher
project or global permission to call this resource. In addition, a user may not reduce their own permission level unless
they have a project or global permission that already implies that permission.

    PUT api/1.0/projects/{projectKey}/repos/{repositorySlug}/permissions/users

Parameters:

=over 4

=item * C<<< name >>> - string, default: none

the names of the users

=item * C<<< permission >>> - string, default: none

the permission to grant

=back

Responses:

=over 4

=item * C<<< 400 >>> - errors, type: application/json

The request was malformed or the specified permission does not exist.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user is not an administrator for the specified
repository.

=item * C<<< 204 >>> - data, type: unknown

The requested permission was granted.

=item * C<<< 403 >>> - errors, type: application/json

The action was disallowed as it would reduce the currently authenticated user's
permission level.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository or user does not exist.

=back

=head2 revoke_repository_permissions_for_user

Revoke all permissions for the specified repository for a user.

The authenticated user must have B<<< REPO_ADMIN >>> permission for the specified repository or a higher
project or global permission to call this resource.

In addition, a user may not revoke their own repository permissions if they do not have a higher
project or global permission.

    DELETE api/1.0/projects/{projectKey}/repos/{repositorySlug}/permissions/users

Parameters:

=over 4

=item * C<<< name >>> - string, default: none

the name of the user

=back

Responses:

=over 4

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user is not an administrator of the specified
repository.

=item * C<<< 204 >>> - data, type: unknown

All repository permissions were revoked from the user for the specified repository.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository or group does not exist.

=item * C<<< 409 >>> - errors, type: application/json

The action was disallowed as it would reduce the currently authenticated user's
permission level.

=back

=head2 get_users_without_repository_permission

Retrieve a page of I<<< licensed >>> users that have no granted permissions for the specified repository.

The authenticated user must have B<<< REPO_ADMIN >>> permission for the specified repository or a higher
project or global permission to call this resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/permissions/users/none

Parameters:

=over 4

=item * C<<< filter >>> - string, default: none

if specified only group names containing the supplied string will be returned

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of users that have not been granted any permissions for the specified
repository.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user is not a repository administrator for the
specified repository.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository does not exist.

=back

=head2 create_pull_request

Create a new pull request between two branches. The branches may be in the same repository, or different ones.
When using different repositories, they must still be in the same hierarchy.

The authenticated user must have B<<< REPO_READ >>> permission for the "from" and "to"repositories to
call this resource.

    POST api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests

Responses:

=over 4

=item * C<<< 201 >>> - pullRequest, type: application/json

The newly created pull request.

=item * C<<< 400 >>> - errors, type: application/json

The pull request entity supplied in the request was malformed.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to create a pull
request between the two specified repositories.

=item * C<<< 404 >>> - errors, type: application/json

One of the specified repositories or branches does not exist.

=item * C<<< 409 >>> - errors, type: application/json

One of the following error cases occurred (check the error message for more details):

=over 4

=item *

There was a problem resolving one or more reviewers.

=item *

The specified branches were the same.

=item *

The I<<< to >>> branch is already up-to-date with all the commits on the
I<<< from >>> branch.

=item *

A pull request between the two branches already exists.

=back

=back

=head2 get_pull_requests

Retrieve a page of pull requests to or from the specified repository.

The authenticated user must have B<<< REPO_READ >>> permission for the specified repository to call
this resource.
Optionally clients can specify PR participant filters. Each filter has a mandatory C<<< username.N >>>
parameter, and the optional C<<< role.N >>> and C<<< approved.N >>> parameters.

=over 4

=item *

C<<< username.N >>> - the "root" of a single participant filter, where "N" is a natural number
starting from 1. This allows clients to specify multiple participant filters, by providing consecutive
filters as C<<< username.1 >>>, C<<< username.2 >>> etc. Note that the filters numbering has to start
with 1 and be continuous for all filters to be processed. The total allowed number of participant
filters is 10 and all filters exceeding that limit will be dropped.

=item *

C<<< role.N >>>(optional) the role associated with C<<< username.N >>>.
This must be one of C<<< AUTHOR >>>, C<<< REVIEWER >>>, orC<<< PARTICIPANT >>>

=item *

C<<< approved.N >>>(optional) the approved status associated with C<<< username.N >>>.
That is whether C<<< username.N >>> has approved the PR. Either C<<< true >>>, or C<<< false >>>

=back

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests

Parameters:

=over 4

=item * C<<< direction >>> - string, default: incoming

(optional, defaults to B<<< INCOMING >>>) the direction relative to the specified
repository. Either B<<< INCOMING >>> or B<<< OUTGOING >>>.

=item * C<<< at >>> - string, default: none

(optional) a I<<< fully-qualified >>> branch ID to find pull requests to or from,
such as C<<< refs/heads/master >>>

=item * C<<< state >>> - string, default: none

(optional, defaults to B<<< OPEN >>>). Supply B<<< ALL >>> to return pull request
in any state. If a state is supplied only pull requests in the specified state will be returned.
Either B<<< OPEN >>>, B<<< DECLINED >>> or B<<< MERGED >>>.

=item * C<<< order >>> - string, default: none

(optional, defaults to B<<< NEWEST >>>) the order to return pull requests in, either
B<<< OLDEST >>> (as in: "oldest first") or B<<< NEWEST >>>.

=item * C<<< withAttributes >>> - boolean, default: true

(optional) defaults to true, whether to return additional pull request attributes

=item * C<<< withProperties >>> - boolean, default: true

(optional) defaults to true, whether to return additional pull request properties

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of pull requests that match the search criteria.

=item * C<<< 400 >>> - errors, type: application/json

The request was malformed.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to view the
specified pull request.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository or pull request does not exist.

=back

=head2 get_pull_request

Retrieve a pull request.

The authenticated user must have B<<< REPO_READ >>> permission for the repository that this pull request
targets to call this resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}

Parameters:

=over 4

=item * C<<< pullRequestId >>> - long, default: none

the ID of the pull request within the repository

=back

Responses:

=over 4

=item * C<<< 200 >>> - pullRequest, type: application/json

The specified pull request.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to view the
specified pull request.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository or pull request does not exist.

=back

=head2 update_pull_request

Update the title, description, reviewers or destination branch of an existing pull request.

B<<< Note: >>> the I<<< reviewers >>> list may be updated using this resource. However the
I<<< author >>> and I<<< participants >>> list may not.

The authenticated user must either:

=over 4

=item *

be the author of the pull request and have the B<<< REPO_READ >>> permission for the repository
that this pull request targets; or

=item *

have the B<<< REPO_WRITE >>> permission for the repository that this pull request targets

=back

to call this resource.

    PUT api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}

Parameters:

=over 4

=item * C<<< pullRequestId >>> - long, default: none

the ID of the pull request within the repository

=back

Responses:

=over 4

=item * C<<< 200 >>> - pullRequest, type: application/json

The updated pull request.

=item * C<<< 400 >>> - errors, type: application/json

One of the following error cases occurred (check the error message for more details):

=over 4

=item *

The request tried to modify the I<<< author >>> or I<<< participants >>>.

=item *

The pull request's version attribute was not specified.

=item *

A reviewer's username was not specified.

=item *

The toRef id value was incorrectly left blank

=back

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to update the
specified pull request.

=item * C<<< 404 >>> - errors, type: application/json

One of the specified repositories or branches does not exist.

=item * C<<< 409 >>> - errors, type: application/json

One of the following error cases occurred (check the error message for more details):

=over 4

=item *

The specified version is out of date.

=item *

One of the reviewers could not be added to the pull request.

=item *

If updating the destination branch:

=over 4

=item *

There is already an open pull request with an identical to branch

=item *

The from and new to branch I<<< are >>> the same

=item *

The new destination branch up-to-date is up-to-date with all of
changes from the from branch, resulting in a pull request with
nothing to merge

=back

=back

=back

=head2 delete_pull_request

Deletes a pull request.

To call this resource, users must be authenticated and have permission to view the pull request.
Additionally, they must:

=over 4

=item *

be the pull request author, if the system is configured to allow authors to delete their own
pull requests (this is the default) OR

=item *

have repository administrator permission for the repository the pull request is targeting

=back

A body containing the version of the pull request must be provided with this request.

    C<<< { "version": 1 } >>>

    DELETE api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}

Parameters:

=over 4

=item * C<<< pullRequestId >>> - long, default: none

the ID of the pull request within the repository

=back

Responses:

=over 4

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to view the
specified pull request.

=item * C<<< 204 >>> - data, type: application/json

=item * C<<< 404 >>> - errors, type: application/json

The specified repository or pull request does not exist.

=back

=head2 get_pull_request_activities

Retrieve a page of activity associated with a pull request.

Activity items include comments, approvals, rescopes (i.e. adding and removing of commits), merges and more.

Different types of activity items may be introduced in newer versions of Stash or by user installed plugins, so
clients should be flexible enough to handle unexpected entity shapes in the returned page.

The authenticated user must have B<<< REPO_READ >>> permission for the repository that this pull request
targets to call this resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/activities

Parameters:

=over 4

=item * C<<< pullRequestId >>> - long, default: none

the id of the pull request within the repository

=item * C<<< fromId >>> - long, default: none

(optional) the id of the activity item to use as the first item in the returned page

=item * C<<< fromType >>> - string, default: none

(required if B<<< fromId >>> is present) the type of the activity item specified by
B<<< fromId >>> (either B<<< COMMENT >>> or B<<< ACTIVITY >>>)

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of activity relating to the specified pull request.

=item * C<<< 400 >>> - errors, type: application/json

The request was malformed.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to view the
specified pull request.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository or pull request does not exist.

=back

=head2 approve_pull_request

Approve a pull request as the current user. Implicitly adds the user as a participant if they are not already.

The authenticated user must have B<<< REPO_READ >>> permission for the repository that this pull request
targets to call this resource.

B<<< Deprecated since 4.2 >>>. Use
/rest/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/participants/{userSlug} instead

    POST api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/approve

Parameters:

=over 4

=item * C<<< pullRequestId >>> - long, default: none

the id of the pull request within the repository

=back

Responses:

=over 4

=item * C<<< 201 >>> - participant, type: application/json

Details of the new participant

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to view the pull request.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository or pull request does not exist.

=item * C<<< 409 >>> - errors, type: application/json

The pull request is not open.

=back

=head2 withdraw_pull_request_approval

Remove approval from a pull request as the current user. This does not remove the user as a participant.

The authenticated user must have B<<< REPO_READ >>> permission for the repository that this pull request
targets to call this resource.

B<<< Deprecated since 4.2 >>>. Use
/rest/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/participants/{userSlug} instead

    DELETE api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/approve

Parameters:

=over 4

=item * C<<< pullRequestId >>> - long, default: none

the id of the pull request within the repository

=back

Responses:

=over 4

=item * C<<< 201 >>> - participant, type: application/json

Details of the updated participant

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to view the pull request.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository or pull request does not exist or the current user is not a participant on the pull request.

=item * C<<< 409 >>> - errors, type: application/json

The pull request is not open.

=back

=head2 stream_pull_request_changes

Gets changes for the specified PullRequest.

If the C<<< changeScope >>> query parameter is set to C<<< unreviewed >>>, the application will attempt to stream
unreviewed changes based on the C<<< lastReviewedCommit >>> of the current user, which are the changes between the
C<<< lastReviewedCommit >>> and the latest commit of the source branch. The current user is considered to
I<<< not >>> have any unreviewed changes for the pull request when the C<<< lastReviewedCommit >>> is either
C<<< null >>> (everything is unreviewed, so all changes are streamed), equal to the latest commit of the source
branch (everything is reviewed), or no longer on the source branch (the source branch has been rebased). In these
cases, the application will fall back to streaming all changes (the default), which is the effective diff for the
pull request. The type of changes streamed can be determined by the C<<< changeScope >>> parameter included in the
properties map of the response.

Note: This resource is currently I<<< not paged >>>. The server will return at most one page. The server will
truncate the number of changes to either the request's page limit or an internal maximum, whichever is smaller.
The start parameter of the page request is also ignored.

The authenticated user must have B<<< REPO_READ >>> permission for the repository that this pull request
targets to call this resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/changes

Parameters:

=over 4

=item * C<<< changeScope >>> - string, default: ALL

C<<< UNREVIEWED >>> to stream the unreviewed changes for the current user (if they exist);
C<<< RANGE >>> to stream changes between two arbitrary commits (requires C<<< sinceId >>> and
C<<< untilId >>>); otherwise C<<< ALL >>> to stream all changes (the default)

=item * C<<< sinceId >>> - string, default: none

the since commit hash to stream changes for a C<<< RANGE >>> arbitrary change scope

=item * C<<< untilId >>> - string, default: none

the until commit hash to stream changes for a C<<< RANGE >>> arbitrary change scope

=item * C<<< withComments >>> - boolean, default: true

C<<< true >>> to apply comment counts in the changes (the default); otherwise, C<<< false >>>
to stream changes without comment counts

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of unreviewed Changes for the current user from the supplied pull
request, including the unreviewedCommits in the properties map.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions
to view the repository or pull request.

=item * C<<< 404 >>> - errors, type: application/json

The repository or pull request does not exist.

=back

=head2 get_pull_request_comments

Gets comments for the specified PullRequest.

The authenticated user must have B<<< REPO_READ >>> permission for the repository that this pull request
targets to call this resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/comments

Parameters:

=over 4

=item * C<<< anchorState >>> - string, default: ACTIVE

C<<< ACTIVE >>> to stream the active comments;
C<<< ORPHANED >>> to stream the orphaned comments;
C<<< ALL >>> to stream both the active and the orphaned comments;

=item * C<<< diffType >>> - string, default: none

C<<< EFFECTIVE >>> to stream the comments related to the effective diff of the pull request;
C<<< RANGE >>> to stream comments related to a commit range between two arbitrary commits
(requires C<<< fromHash >>> and C<<< toHash >>>);
C<<< COMMIT >>> to stream comments related to a commit between two arbitrary commits (requires
C<<< fromHash >>> and C<<< toHash >>>)

=item * C<<< fromHash >>> - string, default: none

the from commit hash to stream comments for a C<<< RANGE >>> or C<<< COMMIT >>> arbitrary change scope

=item * C<<< path >>> - string, default: none

the path to stream comments for a given path

=item * C<<< toHash >>> - string, default: none

the to commit hash to stream comments for a C<<< RANGE >>> or C<<< COMMIT >>> arbitrary change scope

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of Comments from the supplied pull request.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions
to view the repository or pull request.

=item * C<<< 404 >>> - errors, type: application/json

The repository or pull request does not exist.

=back

=head2 create_pull_request_comment

Add a new comment.

Comments can be added in a few places by setting different attributes:

General pull request comment:

    {
       "text" : "An insightful general comment on a pull request."
    }

Reply to a comment:

    {
       "parent" : {
          "id" : 1
       },
       "text" : "A measured reply."
    }

General file comment:

    {
       "anchor" : {
          "diffType" : "RANGE",
          "fromHash" : "6df3858eeb9a53a911cd17e66a9174d44ffb02cd",
          "path" : "path/to/file",
          "srcPath" : "path/to/file",
          "toHash" : "04c7c5c931b9418ca7b66f51fe934d0bd9b2ba4b"
       },
       "text" : "An insightful general comment on a file."
    }

File line comment:

    {
       "anchor" : {
          "diffType" : "COMMIT",
          "fileType" : "FROM",
          "fromHash" : "6df3858eeb9a53a911cd17e66a9174d44ffb02cd",
          "line" : 1,
          "lineType" : "CONTEXT",
          "path" : "path/to/file",
          "srcPath" : "path/to/file",
          "toHash" : "04c7c5c931b9418ca7b66f51fe934d0bd9b2ba4b"
       },
       "text" : "A pithy comment on a particular line within a file."
    }

For file and line comments, 'path' refers to the path of the file to which the comment should be applied and
'srcPath' refers to the path the that file used to have (only required for copies and moves). Also,
fromHash and toHash refer to the sinceId / untilId (respectively) used to produce the diff on which the comment
was added. Finally diffType refers to the type of diff the comment was added on. For backwards compatibility
purposes if no diffType is provided and no fromHash/toHash pair is provided the diffType will be resolved to
'EFFECTIVE'. In any other cases the diffType is REQUIRED.

For line comments, 'line' refers to the line in the diff that the comment should apply to. 'lineType' refers to
the type of diff hunk, which can be:

=over 4

=item *

'ADDED' - for an added line;

=item *

'REMOVED' - for a removed line; or

=item *

'CONTEXT' - for a line that was unmodified but is in the vicinity of the diff.

=back

'fileType' refers to the file of the diff to which the anchor should be attached - which is of relevance when
displaying the diff in a side-by-side way. Currently the supported values are:

=over 4

=item *

'FROM' - the source file of the diff

=item *

'TO' - the destination file of the diff

=back

If the current user is not a participant the user is added as a watcher of the pull request.

The authenticated user must have B<<< REPO_READ >>> permission for the repository that this pull request
targets to call this resource.

    POST api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/comments

Responses:

=over 4

=item * C<<< 201 >>> - comment, type: application/json

The newly created comment.

=item * C<<< 400 >>> - errors, type: application/json

The comment was not created due to a validation error.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to view the pull
request, create a comment or watch the pull request.

=item * C<<< 404 >>> - errors, type: application/json

Unable to find the supplied project, repository, pull request or parent comment

=back

=head2 get_pull_request_comment

Retrieves a pull request comment.

The authenticated user must have B<<< REPO_READ >>> permission for the repository that this pull request
targets to call this resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/comments/{commentId}

Parameters:

=over 4

=item * C<<< commentId >>> - long, default: none

the id of the comment to retrieve

=back

Responses:

=over 4

=item * C<<< 200 >>> - comment, type: application/json

The requested comment.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to view the comment

=item * C<<< 404 >>> - errors, type: application/json

Unable to find the supplied project, repository, pull request or comment

=back

=head2 delete_pull_request_comment

Delete a pull request comment. Anyone can delete their own comment. Only users with B<<< REPO_ADMIN >>>
and above may delete comments created by other users.

The authenticated user must have B<<< REPO_READ >>> permission for the repository that this pull request
targets to call this resource.

    DELETE api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/comments/{commentId}

Parameters:

=over 4

=item * C<<< commentId >>> - long, default: none

the id of the comment to retrieve

=item * C<<< version >>> - int, default: -1

The expected version of the comment. This must match the server's version of the comment or
the delete will fail. To determine the current version of the comment, the comment should be
fetched from the server prior to the delete. Look for the 'version' attribute in the
returned JSON structure.

=back

Responses:

=over 4

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to delete the comment.

=item * C<<< 204 >>> - data, type: unknown

The operation was successful

=item * C<<< 404 >>> - errors, type: application/json

Unable to find the supplied project, repository or pull request.

=item * C<<< 409 >>> - errors, type: application/json

The comment has replies or the version supplied does not match the current version.

=back

=head2 update_pull_request_comment

Update the text of a comment. Only the user who created a comment may update it.

B<<< Note: >>> the supplied supplied JSON object must contain a C<<< version >>> that must match the
server's version of the comment or the update will fail. To determine the current version of
the comment, the comment should be fetched from the server prior to the update. Look for the
'version' attribute in the returned JSON structure.

The authenticated user must have B<<< REPO_READ >>> permission for the repository that this pull request
targets to call this resource.

    PUT api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/comments/{commentId}

Parameters:

=over 4

=item * C<<< commentId >>> - long, default: none

the id of the comment to retrieve

=back

Responses:

=over 4

=item * C<<< 201 >>> - comment, type: application/json

The newly updated comment.

=item * C<<< 400 >>> - errors, type: application/json

The comment was not updated due to a validation error.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to view the pull
request, update a comment or watch the pull request.

=item * C<<< 404 >>> - errors, type: application/json

Unable to find the supplied project, repository, pull request or comment

=item * C<<< 409 >>> - errors, type: application/json

The comment version supplied does not match the current version.

=back

=head2 get_pull_request_commits

Retrieve commits for the specified pull request.

The authenticated user must have B<<< REPO_READ >>> permission for the repository that this pull request
targets to call this resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/commits

Parameters:

=over 4

=item * C<<< pullRequestId >>> - long, default: none

=item * C<<< withCounts >>> - boolean, default: none

if set to true, the service will add "authorCount" and "totalCount" at the end of the page.
"authorCount" is the number of different authors and "totalCount" is the total number of commits.

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

a page of commits from the supplied pull request.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to view the
repository or pull request.

=item * C<<< 404 >>> - errors, type: application/json

The repository or pull request does not exist.

=back

=head2 decline_pull_request

Decline a pull request.

The authenticated user must have B<<< REPO_READ >>> permission for the repository that this pull request
targets to call this resource.

    POST api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/decline

Parameters:

=over 4

=item * C<<< pullRequestId >>> - long, default: none

=item * C<<< version >>> - int, default: -1

the current version of the pull request. If the server's version isn't the same as the specified
version the operation will fail. To determine the current version of the pull request it should be
fetched from the server prior to this operation. Look for the 'version' attribute in the returned
JSON structure.

=back

Responses:

=over 4

=item * C<<< 200 >>> - data, type: unknown

The pull request was declined.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to view the pull
request.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository or pull request does not exist.

=item * C<<< 409 >>> - errors, type: application/json

The pull request is not OPEN or has been updated since the version specified by
the request.

=back

=head2 stream_pull_request_diff

Streams a diff within a pull request.

If the specified file has been copied, moved or renamed, the C<<< srcPath >>> must also be specified to
produce the correct diff.

Note: This RESTful endpoint is currently I<<< not paged >>>. The server will internally apply a hard cap to the
streamed lines, and it is not possible to request subsequent pages if that cap is exceeded.

The authenticated user must have B<<< REPO_READ >>> permission for the repository that this pull request
targets to call this resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/diff/{path:.*}

Parameters:

=over 4

=item * C<<< path >>> - string, default: none

the path to the file which should be diffed (optional)

=item * C<<< contextLines >>> - int, default: -1

the number of context lines to include around added/removed lines in the diff

=item * C<<< diffType >>> - string, default: EFFECTIVE

the type of diff being requested. When C<<< withComments >>> is C<<< true >>>
this works as a hint to the system to attach the correct set of comments to the diff

=item * C<<< sinceId >>> - string, default: none

the since commit hash to stream a diff between two arbitrary hashes

=item * C<<< srcPath >>> - string, default: none

the previous path to the file, if the file has been copied, moved or renamed

=item * C<<< untilId >>> - string, default: none

the until commit hash to stream a diff between two arbitrary hashes

=item * C<<< whitespace >>> - string, default: none

optional whitespace flag which can be set to C<<< ignore-all >>>

=item * C<<< withComments >>> - boolean, default: true

C<<< true >>> to embed comments in the diff (the default); otherwise, C<<< false >>>
to stream the diff without comments

=back

Responses:

=over 4

=item * C<<< 200 >>> - diffs, type: application/json

a page of differences from a pull request.

=item * C<<< 400 >>> - errors, type: application/json

If the request was malformed.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions
to view the repository or pull request.

=item * C<<< 404 >>> - errors, type: application/json

The repository or pull request does not exist.

=back

=head2 merge_pull_request

Merge the specified pull request.

The authenticated user must have B<<< REPO_WRITE >>> permission for the repository that this pull request
targets to call this resource.

    POST api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/merge

Parameters:

=over 4

=item * C<<< pullRequestId >>> - long, default: none

the id of the pull request within the repository

=item * C<<< version >>> - int, default: -1

the current version of the pull request. If the server's version isn't the same as the specified
version the operation will fail. To determine the current version of the pull request it should be
fetched from the server prior to this operation. Look for the 'version' attribute in the returned
JSON structure.

=back

Responses:

=over 4

=item * C<<< 200 >>> - pullRequest, type: application/json

The merged pull request.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to merge the
specified pull request.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository or pull request does not exist.

=item * C<<< 409 >>> - errors, type: application/json

One of the following error cases occurred (check the error message for more details):

=over 4

=item *

The pull request has conflicts.

=item *

A merge check vetoed the merge.

=item *

The specified version is out of date.

=item *

The specified pull request is not open.

=back

=back

=head2 can_merge_pull_request

Test whether a pull request can be merged.

A pull request may not be merged if:

=over 4

=item *

there are conflicts that need to be manually resolved before merging; and/or

=item *

one or more merge checks have vetoed the merge.

=back

The authenticated user must have B<<< REPO_READ >>> permission for the repository that this pull request
targets to call this resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/merge

Parameters:

=over 4

=item * C<<< pullRequestId >>> - long, default: none

the id of the pull request within the repository

=back

Responses:

=over 4

=item * C<<< 200 >>> - pullRequest, type: application/json

The mergeability status of the pull request.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to view the
specified pull request.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository or pull request does not exist.

=item * C<<< 409 >>> - errors, type: application/json

The specified pull request is not open.

=back

=head2 get_pull_request_participants

Retrieves a page of the participants for a given pull request.

The authenticated user must have B<<< REPO_READ >>> permission for the repository that this pull request
targets to call this resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/participants

Parameters:

=over 4

=item * C<<< pullRequestId >>> - long, default: none

the id of the pull request within the repository

=back

Responses:

=over 4

=item * C<<< 201 >>> - page, type: application/json

Details of the participants in this pull request

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to view the pull request.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository or pull request does not exist.

=back

=head2 assign_participant_role

Assigns a participant to an explicit role in pull request. Currently only the REVIEWER role may be assigned.

If the user is not yet a participant in the pull request, they are made one and assigned the supplied role.

If the user is already a participant in the pull request, their previous role is replaced with the supplied role
unless they are already assigned the AUTHOR role which cannot be changed and will result in a Bad Request (400)
response code.

The authenticated user must have B<<< REPO_WRITE >>> permission for the repository that this pull request
targets to call this resource.

    POST api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/participants

Parameters:

=over 4

=item * C<<< pullRequestId >>> - long, default: none

the id of the pull request within the repository

=back

Responses:

=over 4

=item * C<<< 201 >>> - participant, type: application/json

The created or updated participant.

=item * C<<< 400 >>> - errors, type: application/json

The request does not have the username and role, or is attempting an invalid assignment

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to update the pull request.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository or pull request does not exist.

=back

=head2 unassign_participant_role

Unassigns a participant from the REVIEWER role they may have been given in a pull request.

If the participant has no explicit role this method has no effect.

Afterwards, the user will still remain a participant in the pull request but their role will be reduced to
PARTICIPANT. This is because once made a participant of a pull request,
a user will forever remain a participant. Only their role may be altered.

The authenticated user must have B<<< REPO_WRITE >>> permission for the repository that this pull request
targets to call this resource.

B<<< Deprecated since 4.2 >>>. Use
/rest/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/participants/{userSlug}
instead.

    DELETE api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/participants/{userSlug}

Parameters:

=over 4

=item * C<<< pullRequestId >>> - long, default: none

the id of the pull request within the repository

=item * C<<< userSlug >>> - string, default: none

the slug for the user changing their status

=item * C<<< pullRequestId >>> - long, default: none

the id of the pull request within the repository

=back

Responses:

=over 4

=item * C<<< 400 >>> - errors, type: application/json

The request does not have the username

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to update the pull request.

=item * C<<< 204 >>> - data, type: unknown

The update completed.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository or pull request does not exist.

=back

=head2 update_status

Change the current user's status for a pull request. Implicitly adds the user as a participant if they are not
already. If the current user is the author, this method will fail.

The possible values for C<<< status >>> are B<<< UNAPPROVED >>>, B<<< NEEDS_WORK >>>, or
B<<< APPROVED >>>.

If the new C<<< status >>> is B<<< NEEDS_WORK >>> or B<<< APPROVED >>> then the
C<<< lastReviewedCommit >>> for the participant will be updated to the latest commit of the source branch of the
pull request.

The authenticated user must have B<<< REPO_READ >>> permission for the repository that this pull request
targets to call this resource.

    PUT api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/participants/{userSlug}

Parameters:

=over 4

=item * C<<< pullRequestId >>> - long, default: none

the id of the pull request within the repository

=item * C<<< userSlug >>> - string, default: none

the slug for the user changing their status

=item * C<<< pullRequestId >>> - long, default: none

the id of the pull request within the repository

=back

Responses:

=over 4

=item * C<<< 201 >>> - participant, type: application/json

Details of the new participant

=item * C<<< 400 >>> - errors, type: application/json

The specified status was invalid.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to view the pull request.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository or pull request does not exist.

=item * C<<< 409 >>> - errors, type: application/json

The pull request is not open.

=back

=head2 reopen_pull_request

Re-open a declined pull request.

The authenticated user must have B<<< REPO_READ >>> permission for the repository that this pull request
targets to call this resource.

    POST api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/reopen

Parameters:

=over 4

=item * C<<< pullRequestId >>> - long, default: none

the id of the pull request within the repository

=item * C<<< version >>> - int, default: -1

the current version of the pull request. If the server's version isn't the same as the specified
version the operation will fail. To determine the current version of the pull request it should be
fetched from the server prior to this operation. Look for the 'version' attribute in the returned
JSON structure.

=back

Responses:

=over 4

=item * C<<< 200 >>> - pullRequest, type: application/json

The merged pull request.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to reopen the
specified pull request.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository or pull request does not exist.

=item * C<<< 409 >>> - errors, type: application/json

One of the following error cases occurred (check the error message for more
details):

=over 4

=item *

The pull request is not in a declined state.

=item *

The specified version is out of date.

=back

=back

=head2 get_pull_request_tasks

Retrieve the tasks associated with a pull request.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/tasks

Responses:

=over 4

=item * C<<< 200 >>> - task, type: application/json

A page of tasks associated with the pull request.

=item * C<<< 401 >>> - errors, type: application/json

If the current user cannot access the pull request

=item * C<<< 404 >>> - errors, type: application/json

If the pull request does not exist

=back

=head2 count_pull_request_tasks

Retrieve the total number of open and
resolved tasks associated with a pull request.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/tasks/count

Responses:

=over 4

=item * C<<< 200 >>> - taskCount, type: application/json

Total number of open and
resolved tasks associated with the pull request.

=item * C<<< 401 >>> - errors, type: application/json

If the current user cannot access the pull request

=item * C<<< 404 >>> - errors, type: application/json

If the pull request does not exist

=back

=head2 watch_pull_request

Add the authenticated user as a watcher for the specified pull request.

The authenticated user must have B<<< REPO_READ >>> permission for the repository that this pull request
targets to call this resource.

    POST api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/watch

Responses:

=over 4

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to view the pull
request.

=item * C<<< 204 >>> - data, type: unknown

The user is now watching the pull request.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository or pull request does not exist.

=back

=head2 unwatch_pull_request

Remove the authenticated user as a watcher for the specified pull request.

The authenticated user must have B<<< REPO_READ >>> permission for the repository that this pull request
targets to call this resource.

    DELETE api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/watch

Responses:

=over 4

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to view the pull
request.

=item * C<<< 204 >>> - data, type: unknown

The user is no longer watching the pull request.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository or pull request does not exist.

=back

=head2 get_content

Retrieve the raw content for a file path at a specified revision.

The authenticated user must have B<<< REPO_READ >>> permission for the specified repository to call this
resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/raw/{path:.*}

Parameters:

=over 4

=item * C<<< path >>> - string, default: none

the file path to retrieve content from

=item * C<<< at >>> - string, default: none

the commit ID or ref to retrieve the content for.

=item * C<<< markup >>> - string, default: none

if present or C<<< "true" >>>, triggers the raw content to be markup-rendered and returned
as HTML; otherwise, if not specified, or any value other than C<<< "true" >>>, the content
is streamed without markup

=item * C<<< hardwrap >>> - boolean, default: none

(Optional) Whether the markup implementation should convert newlines to breaks.
If not specified, {@link MarkupService} will use the value of the
C<<< markup.render.hardwrap >>> property, which is C<<< true >>> by default

=item * C<<< htmlEscape >>> - boolean, default: none

(Optional) true if HTML should be escaped in the input markup, false otherwise.
If not specified, {@link MarkupService} will use the value of the
C<<< markup.render.html.escape >>> property, which is C<<< true >>> by default

=back

=head2 retry_create_repository

If a create or fork operation fails, calling this method will clean up the broken repository and try again. The
repository must be in an INITIALISATION_FAILED state.

The authenticated user must have B<<< PROJECT_ADMIN >>> permission for the specified project to call this
resource.

    POST api/1.0/projects/{projectKey}/repos/{repositorySlug}/recreate

Parameters:

=over 4

=item * C<<< projectKey >>> - string, default: none

the parent project key

=back

Responses:

=over 4

=item * C<<< 201 >>> - repository, type: application/json

The newly created repository.

=item * C<<< 400 >>> - errors, type: application/json

The repository was not created due to a validation error.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to create a
repository.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository does not exist.

=back

=head2 get_related_repositories

Retrieve repositories which are related to this one. Related repositories are from the same
hierarchy as this repository.

Only repositories to which the authenticated user has B<<< REPO_READ >>> permission will be included, even
if more repositories are part of this repository's hierarchy.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/related

Parameters:

=over 4

=item * C<<< projectKey >>> - string, default: none

the parent project key

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of repositories related to the request repository.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to see the
request repository.

=item * C<<< 404 >>> - errors, type: application/json

The request repository does not exist.

=back

=head2 get_repository_hooks

Retrieve a page of repository hooks for this repository.

The authenticated user must have B<<< REPO_READ >>> permission for the specified repository to call this
resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/hooks

Parameters:

=over 4

=item * C<<< type >>> - string, default: none

the optional type to filter by. Valid values are C<<< PRE_RECEIVE >>> or C<<< POST_RECEIVE >>>

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

returns a page of repository hooks with their associated enabled state.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions
to retrieve the hooks.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository does not exist.

=back

=head2 get_repository_hook

Retrieve a repository hook for this repository.

The authenticated user must have B<<< REPO_READ >>> permission for the specified repository to call this
resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/hooks/{hookKey}

Parameters:

=over 4

=item * C<<< hookKey >>> - string, default: none

=back

Responses:

=over 4

=item * C<<< 200 >>> - data, type: application/json

returns the repository hooks with their associated enabled state
for the supplied hookKey.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions
to retrieve the hook.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository hook does not exist for the given repository, or the
repository does not exist.

=back

=head2 delete_repository_hook

Delete repository hook configuration for the supplied B<<< hookKey >>> and B<<< repositorySlug >>>

The authenticated user must have B<<< REPO_ADMIN >>> permission for the specified repository to call this
resource.

    DELETE api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/hooks/{hookKey}

Parameters:

=over 4

=item * C<<< hookKey >>> - string, default: none

=back

Responses:

=over 4

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions
to delete the hook.

=item * C<<< 204 >>> - data, type: unknown

The hook configuration matching the supplied B<<< hookKey >>> and
B<<< repositorySlug >>> was deleted

=item * C<<< 404 >>> - errors, type: application/json

The specified repository or hook does not exist.

=back

=head2 enable_repository_hook

Enable a repository hook for this repository and optionally apply new configuration.

The authenticated user must have B<<< REPO_ADMIN >>> permission for the specified repository to call this
resource.

A JSON document may be provided to use as the settings for the hook. These structure and validity of
the document is decided by the plugin providing the hook.

    PUT api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/hooks/{hookKey}/enabled

Parameters:

=over 4

=item * C<<< hookKey >>> - string, default: none

=item * C<<< Content-Length >>> - int, default: none

=back

Responses:

=over 4

=item * C<<< 200 >>> - data, type: application/json

returns the repository hooks with their associated enabled state
for the supplied hookKey.

=item * C<<< 400 >>> - errors, type: application/json

The settings specified are invalid.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions
to enable the hook.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository or hook does not exist.

=back

=head2 disable_repository_hook

Disable a repository hook for this repository.

The authenticated user must have B<<< REPO_ADMIN >>> permission for the specified repository to call this
resource.

    DELETE api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/hooks/{hookKey}/enabled

Parameters:

=over 4

=item * C<<< hookKey >>> - string, default: none

=back

Responses:

=over 4

=item * C<<< 200 >>> - data, type: application/json

returns the repository hooks with their associated enabled state
for the supplied hookKey.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions
to disable the hook.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository or hook does not exist.

=back

=head2 get_repository_hook_settings

Retrieve the settings for a repository hook for this repository.

The authenticated user must have B<<< REPO_READ >>> permission for the specified repository to call this
resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/hooks/{hookKey}/settings

Parameters:

=over 4

=item * C<<< hookKey >>> - string, default: none

=back

Responses:

=over 4

=item * C<<< 200 >>> - data, type: application/json

The settings for the hook.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions
to retrieve the hook settings.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository or hook does not exist.

=back

=head2 set_repository_hook_settings

Modify the settings for a repository hook for this repository.

The service will reject any settings which are too large, the current limit is 32KB once serialized.

The authenticated user must have B<<< REPO_ADMIN >>> permission for the specified repository to call this
resource.

A JSON document can be provided to use as the settings for the hook. These structure and validity of the document
is decided by the plugin providing the hook.

    PUT api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/hooks/{hookKey}/settings

Parameters:

=over 4

=item * C<<< hookKey >>> - string, default: none

=back

Responses:

=over 4

=item * C<<< 200 >>> - data, type: application/json

The settings for the hook.

=item * C<<< 400 >>> - errors, type: application/json

The settings specified are invalid.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions
to modify the hook settings.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository or hook does not exist.

=back

=head2 update_repository_pull_request_settings

Update the pull request settings for the context repository.

The authenticated user must have B<<< REPO_ADMIN >>> permission for the context repository to call this
resource.

This resource will call all RestFragments that are registered with the key
B<<< bitbucket.repository.settings.pullRequests >>>. If any fragment fails validations by returning a
non-empty Map of errors, then no fragments will execute.

Only the settings that should be updated need to be included in the request.

The property keys for the settings that are bundled with the application are

=over 4

=item *

mergeConfig - the merge strategy configuration for pull requests

=item *

requiredApprovers - (Deprecated, please use com.atlassian.bitbucket.server.bundled-hooks.requiredApproversMergeHook instead) the number of approvals required on a pull request for it to be mergeable, or 0 to disable the merge check

=item *

com.atlassian.bitbucket.server.bundled-hooks.requiredApproversMergeHook - a json map containing the keys 'enabled' (a boolean to enable or disable this merge check) and 'count' (an integer to set the number of required approvals)

=item *

requiredAllApprovers - whether or not all approvers must approve a pull request for it to be mergeable

=item *

requiredAllTasksComplete - whether or not all tasks on a pull request need to be completed for it to be mergeable

=item *

requiredSuccessfulBuilds - (Deprecated, please use com.atlassian.bitbucket.server.bitbucket-build.requiredBuildsMergeCheck instead) the number of successful builds on a pull request for it to be mergeable, or 0 to disable the merge check

=item *

com.atlassian.bitbucket.server.bitbucket-build.requiredBuildsMergeCheck - a json map containing the keys 'enabled' (a boolean to enable or disable this merge check) and 'count' (an integer to set the number of required builds)

=back

B<<< Merge strategy configuration deletion: >>>

An explicitly set pull request merge strategy configuration can be deleted by POSTing a document with an empty
"mergeConfig" attribute. i.e:

    {
       "mergeConfig" : {}
    }

Upon completion of this request, the effective configuration will be:

=over 4

=item *

The configuration set for this repository's SCM type as set at the project level, if present, otherwise

=item *

the configuration set for this repository's SCM type as set at the instance level, if present, otherwise

=item *

the default configuration for this repository's SCM type

=back

    POST api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/pull-requests

Responses:

=over 4

=item * C<<< 200 >>> - settings, type: application/json

The repository pull request settings for the context repository.

=item * C<<< 400 >>> - errors, type: application/json

The repository pull request settings were not updated due to a validation error.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to see the
specified repository.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository does not exist.

=back

=head2 get_repository_pull_request_settings

Retrieve the pull request settings for the context repository.

The authenticated user must have B<<< REPO_READ >>> permission for the context repository to call this
resource.

This resource will call all RestFragments that are registered with the key
B<<< bitbucket.repository.settings.pullRequests >>>. If any fragment fails validations by returning a
non-empty Map of errors, then no fragments will execute.

The property keys for the settings that are bundled with the application are

=over 4

=item *

mergeConfig - the merge strategy configuration for pull requests

=item *

requiredApprovers - (Deprecated, please use com.atlassian.bitbucket.server.bundled-hooks.requiredApproversMergeHook instead) the number of approvals required on a pull request for it to be mergeable, or 0 if the merge check is disabled

=item *

com.atlassian.bitbucket.server.bundled-hooks.requiredApproversMergeHook - the merge check configuration for required approvers

=item *

requiredAllApprovers - whether or not all approvers must approve a pull request for it to be mergeable

=item *

requiredAllTasksComplete - whether or not all tasks on a pull request need to be completed for it to be mergeable

=item *

requiredSuccessfulBuilds - (Deprecated, please use com.atlassian.bitbucket.server.bitbucket-build.requiredBuildsMergeCheck instead) the number of successful builds on a pull request for it to be mergeable, or 0 if the merge check is disabled

=item *

com.atlassian.bitbucket.server.bitbucket-build.requiredBuildsMergeCheck - the merge check configuration for required builds

=back

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/pull-requests

Responses:

=over 4

=item * C<<< 200 >>> - data, type: application/json

The repository pull request settings for the context repository.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to see the
specified repository.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository does not exist.

=back

=head2 get_tags

Retrieve the tags matching the supplied B<<< filterText >>> param.

The authenticated user must have B<<< REPO_READ >>> permission for the context repository to call this
resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/tags

Parameters:

=over 4

=item * C<<< filterText >>> - string, default: none

the text to match on

=item * C<<< orderBy >>> - string, default: none

ordering of refs either ALPHABETICAL (by name) or MODIFICATION (last updated)

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

The tags matching the supplied B<<< filterText >>>.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to read the
repository.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository does not exist.

=back

=head2 create_tag

Creates a tag using the information provided in the request

The authenticated user must have B<<< REPO_WRITE >>> permission for the context repository to call this
resource.

    POST api/1.0/projects/{projectKey}/repos/{repositorySlug}/tags

Responses:

=over 4

=item * C<<< 200 >>> - tag, type: application/json

The created tag

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to write to the
repository.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository does not exist.

=back

=head2 get_tag

Retrieve a tag in the specified repository.

The authenticated user must have B<<< REPO_READ >>> permission for the context repository to call this
resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/tags/{name:.*}

Parameters:

=over 4

=item * C<<< name >>> - string, default: none

the name of the tag to be retrieved

=back

Responses:

=over 4

=item * C<<< 200 >>> - tag, type: application/json

The tag which matches the supplied B<<< name >>>.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to read the
repository.

=item * C<<< 404 >>> - errors, type: application/json

The specified tag does not exist.

=back

=head2 watch_repository

Add the authenticated user as a watcher for the specified repository.

The authenticated user must have B<<< REPO_READ >>> permission for the repository to call this resource.

    POST api/1.0/projects/{projectKey}/repos/{repositorySlug}/watch

Responses:

=over 4

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to view the
repository.

=item * C<<< 204 >>> - data, type: unknown

The user is now watching the repository.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository does not exist.

=back

=head2 unwatch_repository

Remove the authenticated user as a watcher for the specified repository.

The authenticated user must have B<<< REPO_READ >>> permission for the repository to call this resource.

    DELETE api/1.0/projects/{projectKey}/repos/{repositorySlug}/watch

Responses:

=over 4

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to view the
repository.

=item * C<<< 204 >>> - data, type: unknown

The user is no longer watching the repository.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository does not exist.

=back

=head2 create_webhook

Create a webhook for the repository specified via the URL.

The authenticated user must have B<<< REPO_ADMIN >>> permission for the specified repository to call this
resource.

    POST api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks

Responses:

=over 4

=item * C<<< 200 >>> - webhook, type: application/json

A created webhook.

=item * C<<< 400 >>> - errors, type: application/json

The webhook parameters were invalid or not supplied.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to create webhooks
in the repository.

=item * C<<< 404 >>> - errors, type: application/json

The repository does not exist.

=back

=head2 find_webhooks

Find webhooks in this repository.

The authenticated user must have B<<< REPO_ADMIN >>> permission for the specified repository to call this
resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks

Parameters:

=over 4

=item * C<<< event >>> - string, default: none

list of {@link com.atlassian.webhooks.WebhookEvent} ids to filter for

=item * C<<< statistics >>> - boolean, default: false

C<<< true >>> if statistics should be provided for all found webhooks

=back

Responses:

=over 4

=item * C<<< 200 >>> - webhook, type: application/json

A list of webhooks.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to find webhooks
in the repository.

=item * C<<< 404 >>> - errors, type: application/json

The repository does not exist.

=back

=head2 test_webhook

Test connectivity to a specific endpoint.

The authenticated user must have B<<< REPO_ADMIN >>> permission for the specified repository to call this
resource.

    POST api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks/test

Parameters:

=over 4

=item * C<<< url >>> - string, default: none

the url in which to connect to

=back

Responses:

=over 4

=item * C<<< 200 >>> - webhook, type: application/json

a webhook.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to test a
connection.

=item * C<<< 404 >>> - errors, type: application/json

The repository does not exist.

=back

=head2 delete_webhook

Delete a webhook for the repository specified via the URL.

The authenticated user must have B<<< REPO_ADMIN >>> permission for the specified repository to call this
resource.

    DELETE api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks/{webhookId}

Parameters:

=over 4

=item * C<<< webhookId >>> - int, default: none

the existing webhook id

=back

Responses:

=over 4

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to delete webhooks
in the repository.

=item * C<<< 404 >>> - errors, type: application/json

The repository does not exist, or webhook does not exist in this repository.

=back

=head2 get_webhook

Get a webhook by id.

The authenticated user must have B<<< REPO_ADMIN >>> permission for the specified repository to call this
resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks/{webhookId}

Parameters:

=over 4

=item * C<<< webhookId >>> - int, default: none

the existing webhook id

=item * C<<< statistics >>> - boolean, default: false

=back

Responses:

=over 4

=item * C<<< 200 >>> - webhook, type: application/json

a webhook.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to get a webhook
in the repository.

=item * C<<< 404 >>> - errors, type: application/json

The repository does not exist, or the webhook does not exist in the repository.

=back

=head2 update_webhook

Update an existing webhook.

The authenticated user must have B<<< REPO_ADMIN >>> permission for the specified repository to call this
resource.

    PUT api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks/{webhookId}

Parameters:

=over 4

=item * C<<< webhookId >>> - int, default: none

the existing webhook id

=back

Responses:

=over 4

=item * C<<< 200 >>> - webhook, type: application/json

a webhook.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to update a
webhook in this repository.

=item * C<<< 404 >>> - errors, type: application/json

The repository does not exist, or the webhook does not exist in the repository.

=back

=head2 get_latest_webhook_invocation

Get the latest invocations for a specific webhook.

The authenticated user must have B<<< REPO_ADMIN >>> permission for the specified repository to call this
resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks/{webhookId}/latest

Parameters:

=over 4

=item * C<<< webhookId >>> - int, default: none

id of the webhook

=item * C<<< event >>> - string, default: none

the string id of a specific event to retrieve the last invocation for.

=item * C<<< outcome >>> - string, default: none

the outcome to filter for. Can be SUCCESS, FAILURE, ERROR. None specified means that the all
will be considered

=back

Responses:

=over 4

=item * C<<< 200 >>> - webhookInvocation, type: application/json

a webhook invocation dataset.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to get webhook
invocations in the repository.

=item * C<<< 404 >>> - errors, type: application/json

The repository does not exist, or the webhook does not exist in the repository.

=back

=head2 get_webhook_statistics

Get the statistics for a specific webhook.

The authenticated user must have B<<< REPO_ADMIN >>> permission for the specified repository to call this
resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks/{webhookId}/statistics

Parameters:

=over 4

=item * C<<< webhookId >>> - int, default: none

id of the webhook

=item * C<<< event >>> - string, default: none

the string id of a specific event to retrieve the last invocation for. May be empty, in which
case all events are considered

=back

Responses:

=over 4

=item * C<<< 200 >>> - webhookInvocation, type: application/json

a webhook invocation dataset.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to get webhook
statistics in the repository.

=item * C<<< 404 >>> - errors, type: application/json

The repository does not exist, or the webhook does not exist in the repository.

=back

=head2 get_webhook_statistics_summary

Get the statistics summary for a specific webhook.

The authenticated user must have B<<< REPO_ADMIN >>> permission for the specified repository to call this
resource.

    GET api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks/{webhookId}/statistics/summary

Parameters:

=over 4

=item * C<<< webhookId >>> - int, default: none

id of the webhook

=back

Responses:

=over 4

=item * C<<< 200 >>> - webhookInvocation, type: application/json

a webhook invocation dataset.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to get webhook
statistics summary in the repository.

=item * C<<< 404 >>> - errors, type: application/json

The repository does not exist, or the webhook does not exist in the repository.

=back

=head2 get_repository_hooks_for_project

Retrieve a page of repository hooks for this project.

The authenticated user must have B<<< PROJECT_READ >>> permission for the specified project to call this
resource.

    GET api/1.0/projects/{projectKey}/settings/hooks

Parameters:

=over 4

=item * C<<< type >>> - string, default: none

the optional type to filter by. Valid values are C<<< PRE_RECEIVE >>> or C<<< POST_RECEIVE >>>

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

returns a page of repository hooks with their associated enabled state.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions
to retrieve the hooks.

=item * C<<< 404 >>> - errors, type: application/json

The specified project does not exist.

=back

=head2 get_repository_hook_for_project

Retrieve a repository hook for this project.

The authenticated user must have B<<< PROJECT_READ >>> permission for the specified project to call this
resource.

    GET api/1.0/projects/{projectKey}/settings/hooks/{hookKey}

Parameters:

=over 4

=item * C<<< hookKey >>> - string, default: none

=back

Responses:

=over 4

=item * C<<< 200 >>> - data, type: application/json

returns the repository hooks with their associated enabled state
for the supplied hookKey.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions
to retrieve the hook.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository hook does not exist for the given project,
or the project does not exist.

=back

=head2 enable_repository_hook_for_project

Enable a repository hook for this project and optionally apply new configuration.

The authenticated user must have B<<< PROJECT_ADMIN >>> permission for the specified project to call this
resource.

A JSON document may be provided to use as the settings for the hook. These structure and validity of
the document is decided by the plugin providing the hook.

    PUT api/1.0/projects/{projectKey}/settings/hooks/{hookKey}/enabled

Parameters:

=over 4

=item * C<<< hookKey >>> - string, default: none

=item * C<<< Content-Length >>> - int, default: none

=back

Responses:

=over 4

=item * C<<< 200 >>> - data, type: application/json

returns the repository hooks with their associated enabled state
for the supplied hookKey.

=item * C<<< 400 >>> - errors, type: application/json

The settings specified are invalid.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions
to enable the hook.

=item * C<<< 404 >>> - errors, type: application/json

The specified project or hook does not exist.

=back

=head2 disable_repository_hook_for_project

Disable a repository hook for this project.

The authenticated user must have B<<< PROJECT_ADMIN >>> permission for the specified project to call this
resource.

    DELETE api/1.0/projects/{projectKey}/settings/hooks/{hookKey}/enabled

Parameters:

=over 4

=item * C<<< hookKey >>> - string, default: none

=back

Responses:

=over 4

=item * C<<< 200 >>> - data, type: application/json

returns the repository hooks with their associated enabled state
for the supplied hookKey.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions
to disable the hook.

=item * C<<< 404 >>> - errors, type: application/json

The specified project or hook does not exist.

=back

=head2 get_repository_hook_settings_for_project

Retrieve the settings for a repository hook for this project.

The authenticated user must have B<<< PROJECT_READ >>> permission for the specified project to call this
resource.

    GET api/1.0/projects/{projectKey}/settings/hooks/{hookKey}/settings

Parameters:

=over 4

=item * C<<< hookKey >>> - string, default: none

=back

Responses:

=over 4

=item * C<<< 200 >>> - data, type: application/json

The settings for the hook.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions
to retrieve the hook settings.

=item * C<<< 404 >>> - errors, type: application/json

The specified project or hook does not exist.

=back

=head2 set_repository_hook_settings_for_project

Modify the settings for a repository hook for this project.

The service will reject any settings which are too large, the current limit is 32KB once serialized.

The authenticated user must have B<<< PROJECT_ADMIN >>> permission for the specified project to call this
resource.

A JSON document can be provided to use as the settings for the hook. These structure and validity of the document
is decided by the plugin providing the hook.

    PUT api/1.0/projects/{projectKey}/settings/hooks/{hookKey}/settings

Parameters:

=over 4

=item * C<<< hookKey >>> - string, default: none

=back

Responses:

=over 4

=item * C<<< 200 >>> - data, type: application/json

The settings for the hook.

=item * C<<< 400 >>> - errors, type: application/json

The settings specified are invalid.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions
to modify the hook settings.

=item * C<<< 404 >>> - errors, type: application/json

The specified project or hook does not exist.

=back

=head2 update_project_pull_request_settings

Update the pull request merge strategy configuration for this project and SCM.

The authenticated user must have B<<< PROJECT_ADMIN >>> permission for the context repository to call this
resource.

Only the strategies provided will be enabled, the default must be set and included in the set of strategies.

An explicitly set pull request merge strategy configuration can be deleted by POSTing a document with
an empty "mergeConfig" attribute. i.e:

    {
       "mergeConfig" : {}
    }

Upon completion of this request, the effective configuration will be the configuration explicitly set for
the SCM, or if no such explicit configuration is set then the default configuration will be used.

    POST api/1.0/projects/{projectKey}/settings/pull-requests/{scmId}

Parameters:

=over 4

=item * C<<< scmId >>> - string, default: none

the SCM to get strategies for

=back

Responses:

=over 4

=item * C<<< 200 >>> - strategies, type: application/json

The repository pull request merge strategies for the context repository.

=item * C<<< 400 >>> - errors, type: application/json

The repository pull request merge strategies were not updated due to a validation error.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to administrate the
specified repository.

=item * C<<< 404 >>> - errors, type: application/json

The specified repository does not exist.

=back

=head2 get_project_pull_request_settings

Retrieve the merge strategy configuration for this project and SCM.

The authenticated user must have B<<< PROJECT_READ >>> permission for the context repository to call this
resource.

    GET api/1.0/projects/{projectKey}/settings/pull-requests/{scmId}

Parameters:

=over 4

=item * C<<< scmId >>> - string, default: none

the SCM to get strategies for

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

The merge configuration of the request project.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to see the
request repository.

=item * C<<< 404 >>> - errors, type: application/json

The request repository does not exist.

=back

=head2 find_repositories

Retrieve a page of repositories based on query parameters that control the search. See the documentation of the
parameters for more details.

This resource is anonymously accessible.

B<<< Note on permissions. >>> In absence of the C<<< permission >>> query parameter the implicit 'read' permission
is assumed. Please note that this permission is lower than the REPO_READ permission rather than being equal to
it. The implicit 'read' permission for a given repository is assigned to any user that has any of the higher
permissions, such as C<<< REPO_READ >>>, as well as to anonymous users if the repository is marked as public.
The important implication of the above is that an anonymous request to this resource with a permission level
C<<< REPO_READ >>> is guaranteed to receive an empty list of repositories as a result. For anonymous requests
it is therefore recommended to not specify the C<<< permission >>> parameter at all.

    GET api/1.0/repos

Parameters:

=over 4

=item * C<<< name >>> - string, default: none

(optional) if specified, this will limit the resulting repository list to ones whose name
matches this parameter's value. The match will be done case-insensitive and any leading
and/or trailing whitespace characters on the C<<< name >>> parameter will be stripped.

=item * C<<< projectname >>> - string, default: none

(optional) if specified, this will limit the resulting repository list to ones whose project's
name matches this parameter's value. The match will be done case-insensitive and any leading
and/or trailing whitespace characters on the C<<< projectname >>> parameter will
be stripped.

=item * C<<< permission >>> - string, default: none

(optional) if specified, it must be a valid repository permission level name and will limit
the resulting repository list to ones that the requesting user has the specified permission
level to. If not specified, the default implicit 'read' permission level will be assumed. The
currently supported explicit permission values are C<<< REPO_READ >>>, C<<< REPO_WRITE >>>
and C<<< REPO_ADMIN >>>.

=item * C<<< visibility >>> - string, default: none

(optional) if specified, this will limit the resulting repository list based on the
repositories visibility. Valid values are I<<< public >>> or I<<< private >>>.

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of repositories.

=item * C<<< 400 >>> - errors, type: application/json

The C<<< visibility >>> parameter contains an invalid value

=back

=head2 create_task

Create a new task.

    POST api/1.0/tasks

Responses:

=over 4

=item * C<<< 201 >>> - task, type: application/json

A copy of the created task.

=item * C<<< 400 >>> - errors, type: application/json

If the task data is invalid (for example, if the task's text is missing or blank)

=item * C<<< 404 >>> - errors, type: application/json

If the anchor of the task (such as a pull request comment) does not exist or is not visible to the current user

=back

=head2 get_task

Retrieve a existing task.

    GET api/1.0/tasks/{taskId}

Parameters:

=over 4

=item * C<<< taskId >>> - long, default: none

the id identifying the task to delete

=back

Responses:

=over 4

=item * C<<< 200 >>> - task, type: application/json

A copy of the task.

=item * C<<< 404 >>> - errors, type: application/json

If the task does not exist

=back

=head2 delete_task

Delete a task.

Note that only the task's creator, the context's author or an admin of the context's repository can delete a
task. (For a pull request task, those are the task's creator, the pull request's author or an admin on the
repository containing the pull request). Additionally a task cannot be deleted if it has already been resolved.

    DELETE api/1.0/tasks/{taskId}

Parameters:

=over 4

=item * C<<< taskId >>> - long, default: none

the id identifying the task to delete

=back

Responses:

=over 4

=item * C<<< 401 >>> - errors, type: application/json

If the current user does not have the permission to delete the task

=item * C<<< 204 >>> - task, type: unknown

if the task was successfully deleted.

=item * C<<< 404 >>> - errors, type: application/json

If the task does not exist

=item * C<<< 409 >>> - errors, type: application/json

If the task to delete is in the resolved state

=back

=head2 update_task

Update a existing task.

As of Stash 3.3, only the state and text of a task can be updated.

Updating the state of a task is allowed for any user having I<<< READ >>> access to the repository.
However only the task's creator, the context's author or an admin of the context's repository can update the
task's text. (For a pull request task, those are the task's creator, the pull request's author or an admin on the
repository containing the pull request). Additionally the task's text cannot be updated if it has been resolved.

    PUT api/1.0/tasks/{taskId}

Parameters:

=over 4

=item * C<<< taskId >>> - long, default: none

the id identifying the task to delete

=back

Responses:

=over 4

=item * C<<< 200 >>> - task, type: application/json

A copy of the task if it was successfully updated.

=item * C<<< 401 >>> - errors, type: application/json

If the current user does not have the permission to update the task

=item * C<<< 404 >>> - errors, type: application/json

If the task does not exist

=item * C<<< 409 >>> - errors, type: application/json

If the task to update is in the resolved state

=back

=head2 find_users

Retrieve a page of users, optionally run through provided filters.

Only authenticated users may call this resource.

=head3 Supported Filters

Filters are provided in query parameters in a standard C<<< name=value >>> fashion. The following filters are
currently supported:

=over 4

=item *

C<<< filter >>> - return only users, whose username, name or email address I<<< contain >>> the
C<<< filter >>> value

=item *

C<<< group >>> - return only users who are members of the given group

=item *

C<<< permission >>> - the "root" of a permission filter, whose value must be a valid global,
project, or repository permission. Additional filter parameters referring to this filter that specify the
resource (project or repository) to apply the filter to must be prefixed with C<<< permission. >>>. See the
section "Permission Filters" below for more details.

=item *

C<<< permission.N >>> - the "root" of a single permission filter, similar to the C<<< permission >>>
parameter, where "N" is a natural number starting from 1. This allows clients to specify multiple permission
filters, by providing consecutive filters as C<<< permission.1 >>>, C<<< permission.2 >>> etc. Note that
the filters numbering has to start with 1 and be continuous for all filters to be processed. The total allowed
number of permission filters is 50 and all filters exceeding that limit will be dropped. See the section
"Permission Filters" below for more details on how the permission filters are processed.

=back

=head3 Permission Filters

The following three sub-sections list parameters supported for permission filters (where C<<< [root] >>> is
the root permission filter name, e.g. C<<< permission >>>, C<<< permission.1 >>> etc.) depending on the
permission resource. The system determines which filter to apply (Global, Project or Repository permission)
based on the C<<< [root] >>> permission value. E.g. C<<< ADMIN >>> is a global permission,
C<<< PROJECT_ADMIN >>> is a project permission and C<<< REPO_ADMIN >>> is a repository permission. Note
that the parameters for a given resource will be looked up in the order as they are listed below, that is e.g.
for a project resource, if both C<<< projectId >>> and C<<< projectKey >>> are provided, the system will
use C<<< projectId >>> for the lookup.

=head4 Global permissions

The permission value under C<<< [root] >>> is the only required and recognized parameter, as global
permissions do not apply to a specific resource.

Example valid filter: C<<< permission=ADMIN >>>.

=head4 Project permissions

=over 4

=item *

C<<< [root] >>>- specifies the project permission

=item *

C<<< [root].projectId >>> - specifies the project ID to lookup the project by

=item *

C<<< [root].projectKey >>> - specifies the project key to lookup the project by

=back

Example valid filter: C<<< permission.1=PROJECT_ADMIN&permission.1.projectKey=TEST_PROJECT >>>.

=head4 Repository permissions

=over 4

=item *

C<<< [root] >>>- specifies the repository permission

=item *

C<<< [root].projectId >>> - specifies the repository ID to lookup the repository by

=item *

C<<< [root].projectKey >>> and C<<< [root].repositorySlug >>>- specifies the project key and
repository slug to lookup the repository by; both values I<<< need to >>> be provided for this look up to be
triggered

=back

Example valid filter: C<<< permission.2=REPO_ADMIN&permission.2.projectKey=TEST_PROJECT&permission.2.repositorySlug=test_repo >>>.

    GET api/1.0/users

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of users.

=item * C<<< 400 >>> - errors, type: application/json

The search request was invalid, which may happen for multiple reasons, among
others:

=over 4

=item *

permission filter for project/repository permission with no parameters specifying the project or
repository to apply the filter to

=item *

invalid permission name

=item *

permission filter for a project/repository permission pointing to a non-existent project or repository

=back

The exact reason for the error and - in most cases - the request parameter name that had invalid value - will be
provided in the error message.

=item * C<<< 401 >>> - errors, type: application/json

Authentication failed or was not attempted.

=back

=head2 update_current_user

Update the currently authenticated user's details. The update will always be applied to the currently
authenticated user.

    PUT api/1.0/users

Responses:

=over 4

=item * C<<< 200 >>> - detailedUser, type: application/json

The updated user.

=item * C<<< 400 >>> - errors, type: application/json

The request was malformed.

=item * C<<< 401 >>> - errors, type: application/json

Authentication failed or was not attempted.

=back

=head2 update_current_user_password

Update the currently authenticated user's password.

    PUT api/1.0/users/credentials

Responses:

=over 4

=item * C<<< 400 >>> - errors, type: application/json

The request was malformed or the old password was incorrect.

=item * C<<< 401 >>> - errors, type: application/json

Authentication failed or was not attempted.

=item * C<<< 204 >>> - data, type: unknown

The user's password was successfully updated.

=back

=head2 get_user

Retrieve the user matching the supplied B<<< userSlug >>>.

    GET api/1.0/users/{userSlug}

Responses:

=over 4

=item * C<<< 200 >>> - userSlug, type: application/json

The user matching the supplied B<<< userSlug >>>. Note, this may
I<<< not >>> be the user's username, always use the B<<< user.slug >>> property.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to view the user.

=item * C<<< 404 >>> - errors, type: application/json

The specified user does not exist.

=back

=head2 delete_user_avatar

Delete the avatar associated to a user.

Users are always allowed to delete their own avatar. To delete someone else's avatar the authenticated user must
have global B<<< ADMIN >>> permission, or global B<<< SYS_ADMIN >>> permission to update a
B<<< SYS_ADMIN >>> user's avatar.

    DELETE api/1.0/users/{userSlug}/avatar.png

Responses:

=over 4

=item * C<<< 200 >>> - href, type: application/json

The new avatar URL if the local avatar was successfully deleted or did not exist

=item * C<<< 401 >>> - errors, type: application/json

The authenticated user has insufficient permissions to delete the specified avatar.

=item * C<<< 404 >>> - errors, type: application/json

The specified user does not exist.

=back

=head2 upload_user_avatar

Update the avatar for the user with the supplied B<<< slug >>>.

This resource accepts POST multipart form data, containing a single image in a form-field named 'avatar'.

There are configurable server limits on both the dimensions (1024x1024 pixels by default) and uploaded
file size (1MB by default). Several different image formats are supported, but B<<< PNG >>> and
B<<< JPEG >>> are preferred due to the file size limit.

This resource has Cross-Site Request Forgery (XSRF) protection. To allow the request to
pass the XSRF check the caller needs to send an C<<< X-Atlassian-Token >>> HTTP header with the
value C<<< no-check >>>.

An example L<<< curl|http://curl.haxx.se/ >>> request to upload an image name 'avatar.png' would be:

    curl -X POST -u username:password -H "X-Atlassian-Token: no-check" http://example.com/rest/api/latest/users/jdoe/avatar.png -F avatar=@avatar.png

Users are always allowed to update their own avatar. To update someone else's avatar the authenticated user must
have global B<<< ADMIN >>> permission, or global B<<< SYS_ADMIN >>> permission to update a
B<<< SYS_ADMIN >>> user's avatar.

    POST api/1.0/users/{userSlug}/avatar.png

Responses:

=over 4

=item * C<<< 201 >>> - data, type: unknown

The avatar was uploaded successfully.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user has insufficient permissions to update the
avatar.

=item * C<<< 404 >>> - errors, type: application/json

The specified user does not exist.

=back

=head2 get_user_settings

Retrieve a map of user setting key values for a specific user identified by the user slug.

    GET api/1.0/users/{userSlug}/settings

Responses:

=over 4

=item * C<<< 200 >>> - settings, type: application/json

The user settings for the specified user slug.

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user is not a project administrator.

=back

=head2 update_user_settings

Update the entries of a map of user setting key/values for a specific user identified by the user slug.

    POST api/1.0/users/{userSlug}/settings

Responses:

=over 4

=item * C<<< 200 >>> - data, type: unknown

The were updated successfully

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user is not a project administrator.

=back

=head1 SEE ALSO

=over 4

=item * L<WebService::BitbucketServer>

=item * L<https://developer.atlassian.com/bitbucket/server/docs/latest/>

=back

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/chazmcgarvey/WebService-BitbucketServer/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Charles McGarvey <chazmcgarvey@brokenzipper.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Charles McGarvey.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
