# Generated by default/object.tt
package Paws::Proton::ServiceTemplateSummary;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest'], required => 1);
  has CreatedAt => (is => 'ro', isa => 'Str', request_name => 'createdAt', traits => ['NameInRequest'], required => 1);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has DisplayName => (is => 'ro', isa => 'Str', request_name => 'displayName', traits => ['NameInRequest']);
  has LastModifiedAt => (is => 'ro', isa => 'Str', request_name => 'lastModifiedAt', traits => ['NameInRequest'], required => 1);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest'], required => 1);
  has PipelineProvisioning => (is => 'ro', isa => 'Str', request_name => 'pipelineProvisioning', traits => ['NameInRequest']);
  has RecommendedVersion => (is => 'ro', isa => 'Str', request_name => 'recommendedVersion', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Proton::ServiceTemplateSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Proton::ServiceTemplateSummary object:

  $service_obj->Method(Att1 => { Arn => $value, ..., RecommendedVersion => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Proton::ServiceTemplateSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

The service template summary data.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Arn => Str

The Amazon Resource Name (ARN) of the service template.


=head2 B<REQUIRED> CreatedAt => Str

The time when the service template was created.


=head2 Description => Str

A description of the service template.


=head2 DisplayName => Str

The service template name as displayed in the developer interface.


=head2 B<REQUIRED> LastModifiedAt => Str

The time when the service template was last modified.


=head2 B<REQUIRED> Name => Str

The name of the service template.


=head2 PipelineProvisioning => Str

If C<pipelineProvisioning> is C<true>, a service pipeline is included
in the service template, otherwise a service pipeline I<isn't> included
in the service template.


=head2 RecommendedVersion => Str

The ID of the recommended version of the service template.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Proton>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

