/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.openqa.grid.internal.utils.CapabilityMatcher;
import org.openqa.selenium.Platform;

public class DefaultCapabilityMatcher
implements CapabilityMatcher {
    private static final Logger log = Logger.getLogger(DefaultCapabilityMatcher.class.getName());
    private static final String GRID_TOKEN = "_";
    protected final List<String> toConsider = new ArrayList<String>();

    public DefaultCapabilityMatcher() {
        this.toConsider.add("platform");
        this.toConsider.add("browserName");
        this.toConsider.add("version");
        this.toConsider.add("browserVersion");
        this.toConsider.add("applicationName");
    }

    public void addToConsider(String capabilityName) {
        this.toConsider.add(capabilityName);
    }

    @Override
    public boolean matches(Map<String, Object> nodeCapability, Map<String, Object> requestedCapability) {
        if (nodeCapability == null || requestedCapability == null) {
            return false;
        }
        block9: for (String key : requestedCapability.keySet()) {
            String value;
            if (key.startsWith(GRID_TOKEN) || !this.toConsider.contains(key) || requestedCapability.get(key) == null || "ANY".equalsIgnoreCase(value = requestedCapability.get(key).toString()) || "".equals(value) || "*".equals(value)) continue;
            switch (key) {
                case "platform": {
                    Platform requested = this.extractPlatform(requestedCapability.get(key));
                    if (requested == null) continue block9;
                    Platform node = this.extractPlatform(nodeCapability.get(key));
                    if (node == null) {
                        return false;
                    }
                    if (node.is(requested)) continue block9;
                    return false;
                }
                case "browserVersion": 
                case "version": {
                    Object nodeVersion = nodeCapability.getOrDefault("browserVersion", nodeCapability.get("version"));
                    if (value.equals(nodeVersion)) continue block9;
                    return false;
                }
                default: {
                    if (requestedCapability.get(key).equals(nodeCapability.get(key))) continue block9;
                    return false;
                }
            }
        }
        return true;
    }

    Platform extractPlatform(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Platform) {
            return (Platform)((Object)o);
        }
        if (o instanceof String) {
            String name = o.toString();
            try {
                return Platform.valueOf(name);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                for (Platform os : Platform.values()) {
                    for (String matcher : os.getPartOfOsName()) {
                        if ("".equals(matcher) || !name.equalsIgnoreCase(matcher)) continue;
                        return os;
                    }
                }
                return null;
            }
        }
        return null;
    }
}

