# Generated by default/object.tt
package Paws::MediaLive::MotionGraphicsActivateScheduleActionSettings;
  use Moose;
  has Duration => (is => 'ro', isa => 'Int', request_name => 'duration', traits => ['NameInRequest']);
  has PasswordParam => (is => 'ro', isa => 'Str', request_name => 'passwordParam', traits => ['NameInRequest']);
  has Url => (is => 'ro', isa => 'Str', request_name => 'url', traits => ['NameInRequest']);
  has Username => (is => 'ro', isa => 'Str', request_name => 'username', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaLive::MotionGraphicsActivateScheduleActionSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaLive::MotionGraphicsActivateScheduleActionSettings object:

  $service_obj->Method(Att1 => { Duration => $value, ..., Username => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaLive::MotionGraphicsActivateScheduleActionSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->Duration

=head1 DESCRIPTION

Settings to specify the rendering of motion graphics into the video
stream.

=head1 ATTRIBUTES


=head2 Duration => Int

Duration (in milliseconds) that motion graphics should render on to the
video stream. Leaving out this property or setting to 0 will result in
rendering continuing until a deactivate action is processed.


=head2 PasswordParam => Str

Key used to extract the password from EC2 Parameter store


=head2 Url => Str

URI of the HTML5 content to be rendered into the live stream.


=head2 Username => Str

Documentation update needed



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaLive>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

